/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.logdb.client.http.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.concurrent.CopyOnWriteArraySet;
import org.araqne.logdb.client.Message;
import org.araqne.logdb.client.http.impl.MessageCodec;
import org.araqne.logdb.client.http.impl.TrapListener;
import org.json.JSONArray;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrapReceiver
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(TrapReceiver.class);
    private boolean doStop;
    private String host;
    private int port;
    private String cookie;
    private CopyOnWriteArraySet<TrapListener> listeners;
    private HttpURLConnection con;

    public TrapReceiver(String host, String cookie) {
        this(host, 80, cookie);
    }

    public TrapReceiver(String host, int port, String cookie) {
        this.host = host;
        this.port = port;
        this.cookie = cookie;
        this.listeners = new CopyOnWriteArraySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.logger.trace("logdb client: trap thread started");
            while (!this.doStop) {
                this.receiveTrap();
            }
        }
        catch (SocketException e) {
            if (e.getMessage().equalsIgnoreCase("socket closed")) {
                return;
            }
        }
        catch (Throwable t) {
            this.logger.error("logdb client: trap receiver error", t);
        }
        finally {
            this.logger.trace("logdb client: trap thread stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveTrap() throws SocketException {
        InputStream is = null;
        try {
            int read;
            this.con = (HttpURLConnection)new URL("http://" + this.host + ":" + this.port + "/msgbus/trap").openConnection();
            this.con.setRequestProperty("Content-Type", "text/json");
            this.con.setRequestProperty("Cookie", this.cookie);
            this.con.setConnectTimeout(5000);
            this.con.setReadTimeout(5000);
            is = this.con.getInputStream();
            ByteArrayOutputStream bos = null;
            bos = this.con.getContentLength() > 0 ? new ByteArrayOutputStream(this.con.getContentLength()) : new ByteArrayOutputStream();
            byte[] b = new byte[8096];
            while ((read = is.read(b)) >= 0) {
                bos.write(b, 0, read);
            }
            String text = new String(bos.toByteArray(), "utf-8");
            if (text.isEmpty()) {
                return;
            }
            JSONTokener tokenizer = new JSONTokener(new StringReader(text));
            JSONArray container = (JSONArray)tokenizer.nextValue();
            for (int i = 0; i < container.length(); ++i) {
                JSONArray obj = container.getJSONArray(i);
                Message msg = MessageCodec.decode(obj.toString());
                this.invokeTrapCallbacks(msg);
            }
        }
        catch (SocketTimeoutException e) {
            this.logger.debug("logdb client: socket timeout");
        }
        catch (ConnectException e) {
            throw e;
        }
        catch (SocketException e) {
            if (e.getMessage().equalsIgnoreCase("socket closed")) {
                throw e;
            }
            this.logger.error("logdb client: cannot fetch trap", e);
        }
        catch (Throwable t) {
            this.logger.error("logdb client: cannot fetch trap", t);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (this.con != null) {
                this.con.disconnect();
                this.con = null;
            }
        }
    }

    private void invokeTrapCallbacks(Message msg) {
        for (TrapListener listener : this.listeners) {
            try {
                listener.onTrap(msg);
            }
            catch (Throwable t) {
                this.logger.error("logdb client: listener should not throw any exception", t);
            }
        }
    }

    public void addListener(TrapListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TrapListener listener) {
        this.listeners.remove(listener);
    }

    public void close() {
        try {
            this.doStop = true;
            if (this.con != null) {
                this.con.disconnect();
            }
            this.interrupt();
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

