/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.logdb.client.http.impl;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.Deflater;
import java.util.zip.GZIPOutputStream;
import org.araqne.codec.Base64;
import org.araqne.codec.FastEncodingRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingResultEncoder {
    private final Logger slog = LoggerFactory.getLogger(StreamingResultEncoder.class);
    private ThreadPoolExecutor executor;
    private int poolSize;

    public StreamingResultEncoder(String name, int poolSize) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("pool size should be positive");
        }
        this.poolSize = poolSize;
        this.executor = new ThreadPoolExecutor(poolSize, poolSize, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(poolSize), new NamedThreadFactory(name), new ThreadPoolExecutor.CallerRunsPolicy());
        this.slog.debug("araqne logdb: created encoder thread pool [{}]", poolSize);
    }

    public List<Map<String, Object>> encode(List<Object> rows, boolean useGzip) throws InterruptedException, ExecutionException {
        int flushSize = (rows.size() + this.poolSize) / this.poolSize;
        ArrayList<Map<String, Object>> chunks = new ArrayList<Map<String, Object>>();
        ArrayList<Future<Map<String, Object>>> futures = new ArrayList<Future<Map<String, Object>>>();
        int total = rows.size();
        int from = 0;
        boolean exit = false;
        while (!exit) {
            int to = from + flushSize;
            if (to >= total) {
                to = total;
                exit = true;
            }
            List<Object> list = rows.subList(from, to);
            Future<Map<String, Object>> future = this.executor.submit(new Encoder(list, useGzip));
            futures.add(future);
            from = to;
        }
        for (Future future : futures) {
            do {
                Map chunk;
                if ((chunk = (Map)future.get()) == null) continue;
                chunks.add(chunk);
            } while (!future.isDone());
        }
        return chunks;
    }

    public void close() {
        this.executor.shutdown();
        this.slog.debug("araqne logdb: closed encoder thread pool [{}]", this.poolSize);
    }

    private abstract class FunctorBase<T>
    implements Callable<T> {
        private final Logger logger;

        public FunctorBase(Logger logger) {
            this.logger = logger;
        }

        @Override
        public final T call() {
            try {
                return this.callSafely();
            }
            catch (Throwable t) {
                if (this.logger != null) {
                    this.logger.error("unexpected error while running Task", t);
                } else {
                    System.err.println("unexpected error while running Task");
                    t.printStackTrace(System.err);
                }
                throw new IllegalStateException(t);
            }
        }

        protected abstract T callSafely() throws Exception;
    }

    private class NamedThreadFactory
    implements ThreadFactory {
        private final String prefix;

        public NamedThreadFactory(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, this.prefix);
        }
    }

    private class Encoder
    extends FunctorBase<Map<String, Object>> {
        private List<Object> rows;
        private boolean useGzip;

        public Encoder(List<Object> rows, boolean useGzip) {
            super(StreamingResultEncoder.this.slog);
            this.rows = rows;
            this.useGzip = useGzip;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Map<String, Object> callSafely() throws Exception {
            int len = this.rows.size();
            HashMap<String, Object[]> columns = new HashMap<String, Object[]>();
            int i = 0;
            for (Object o : this.rows) {
                Map rows = (Map)o;
                for (Map.Entry e : rows.entrySet()) {
                    String key = (String)e.getKey();
                    Object[] items = (Object[])columns.get(key);
                    if (items == null) {
                        items = new Object[len];
                        columns.put(key, items);
                    }
                    items[i] = e.getValue();
                }
                ++i;
            }
            HashMap<String, Object> msg = new HashMap<String, Object>();
            FastEncodingRule enc = new FastEncodingRule();
            ByteBuffer bb = enc.encode(columns);
            ByteBuffer compressed = null;
            int compressedSize = 0;
            if (this.useGzip) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                GZIPOutputStream zos = null;
                try {
                    zos = new GZIPOutputStream(bos);
                    zos.write(bb.array());
                    zos.finish();
                    byte[] out = bos.toByteArray();
                    compressed = ByteBuffer.wrap(out);
                    compressedSize = out.length;
                }
                finally {
                    if (zos != null) {
                        zos.close();
                    }
                }
            }
            Deflater c = new Deflater();
            try {
                c.setInput(bb.array(), 0, bb.array().length);
                c.finish();
                compressed = ByteBuffer.allocate(bb.array().length * 2);
                compressedSize = c.deflate(compressed.array());
                compressed = ByteBuffer.wrap(Arrays.copyOf(compressed.array(), compressedSize));
            }
            finally {
                c.end();
            }
            msg.put("size", bb.array().length);
            msg.put("bin", new String(Base64.encode(compressed.array())));
            return msg;
        }
    }
}

