/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.logdb.client.http;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.araqne.logdb.client.AccountInfo;
import org.araqne.logdb.client.ArchiveConfig;
import org.araqne.logdb.client.ConfigSpec;
import org.araqne.logdb.client.IndexConfigSpec;
import org.araqne.logdb.client.IndexInfo;
import org.araqne.logdb.client.IndexTokenizerFactoryInfo;
import org.araqne.logdb.client.LogCursor;
import org.araqne.logdb.client.LogQuery;
import org.araqne.logdb.client.LoggerFactoryInfo;
import org.araqne.logdb.client.LoggerInfo;
import org.araqne.logdb.client.Message;
import org.araqne.logdb.client.MessageException;
import org.araqne.logdb.client.ParserFactoryInfo;
import org.araqne.logdb.client.Privilege;
import org.araqne.logdb.client.TableSchemaInfo;
import org.araqne.logdb.client.http.impl.CometSession;
import org.araqne.logdb.client.http.impl.TrapListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CometClient
implements TrapListener {
    private final Logger logger = LoggerFactory.getLogger(CometClient.class);
    private CometSession session;
    private Map<Integer, LogQuery> queries = new HashMap<Integer, LogQuery>();

    public List<LogQuery> getQueries() {
        return new ArrayList<LogQuery>(this.queries.values());
    }

    public LogQuery getQuery(int id) {
        return this.queries.get(id);
    }

    public void connect(String host, String loginName, String password) throws IOException {
        this.connect(host, 80, loginName, password);
    }

    public void connect(String host, int port, String loginName, String password) throws IOException {
        this.session = new CometSession(host, port);
        this.session.login(loginName, password, true);
        this.session.addListener(this);
    }

    public List<ArchiveConfig> listArchiveConfigs() throws IOException {
        ArrayList<ArchiveConfig> configs = new ArrayList<ArchiveConfig>();
        Message resp = this.session.rpc("com.logpresso.core.msgbus.ArchivePlugin.getConfigs");
        List l = (List)resp.get("configs");
        for (Map m : l) {
            configs.add(this.parseArchiveConfig(m));
        }
        return configs;
    }

    public ArchiveConfig getArchiveConfig(String loggerName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("logger", loggerName);
        Message resp = this.session.rpc("com.logpresso.core.msgbus.ArchivePlugin.getConfig", params);
        Map m = (Map)resp.getParameters().get("config");
        return this.parseArchiveConfig(m);
    }

    private ArchiveConfig parseArchiveConfig(Map<String, Object> m) {
        ArchiveConfig c = new ArchiveConfig();
        c.setLoggerName((String)m.get("logger"));
        c.setTableName((String)m.get("table"));
        c.setHost((String)m.get("host"));
        c.setEnabled((Boolean)m.get("enabled"));
        c.setMetadata((Map)m.get("metadata"));
        return c;
    }

    public void createArchiveConfig(ArchiveConfig config) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("logger", config.getLoggerName());
        params.put("table", config.getTableName());
        params.put("host", config.getHost());
        params.put("enabled", config.isEnabled());
        params.put("metadata", config.getMetadata());
        this.session.rpc("com.logpresso.core.msgbus.ArchivePlugin.createConfig", params);
    }

    public void removeArchiveConfig(String loggerName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("logger", loggerName);
        this.session.rpc("com.logpresso.core.msgbus.ArchivePlugin.removeConfig", params);
    }

    public List<AccountInfo> listAccounts() throws IOException {
        Message resp = this.session.rpc("org.araqne.logdb.msgbus.ManagementPlugin.listAccounts");
        ArrayList<AccountInfo> accounts = new ArrayList<AccountInfo>();
        List l = (List)resp.get("accounts");
        for (Object o : l) {
            Map m = (Map)o;
            List pl = (List)m.get("privileges");
            AccountInfo account = new AccountInfo();
            String loginName = (String)m.get("login_name");
            account.setLoginName(loginName);
            for (Object o2 : pl) {
                Map m2 = (Map)o2;
                String tableName = (String)m2.get("table_name");
                Privilege p = new Privilege(loginName, tableName);
                account.getPrivileges().add(p);
            }
            accounts.add(account);
        }
        return accounts;
    }

    public void createAccount(AccountInfo account) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("login_name", account.getLoginName());
        params.put("password", account.getPassword());
        this.session.rpc("org.araqne.logdb.msgbus.ManagementPlugin.createAccount", params);
    }

    public void removeAccount(String loginName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("login_name", loginName);
        this.session.rpc("org.araqne.logdb.msgbus.ManagementPlugin.removeAccount", params);
    }

    public void changePassword(String loginName, String password) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("login_name", loginName);
        params.put("password", password);
        this.session.rpc("org.araqne.logdb.msgbus.ManagementPlugin.changePassword", params);
    }

    public void grantPrivilege(Privilege privilege) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("login_name", privilege.getLoginName());
        params.put("table_name", privilege.getTableName());
        this.session.rpc("org.araqne.logdb.msgbus.ManagementPlugin.grantPrivilege", params);
    }

    public void revokePrivilege(Privilege privilege) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("login_name", privilege.getLoginName());
        params.put("table_name", privilege.getTableName());
        this.session.rpc("org.araqne.logdb.msgbus.ManagementPlugin.revokePrivilege", params);
    }

    public List<IndexTokenizerFactoryInfo> listIndexTokenizerFactories() throws IOException {
        Message resp = this.session.rpc("com.logpresso.index.msgbus.ManagementPlugin.listIndexTokenizerFactories");
        ArrayList<IndexTokenizerFactoryInfo> l = new ArrayList<IndexTokenizerFactoryInfo>();
        for (Object o : (List)resp.getParameters().get("factories")) {
            IndexTokenizerFactoryInfo f = this.parseIndexTokenizerFactory(o);
            l.add(f);
        }
        return l;
    }

    public IndexTokenizerFactoryInfo getIndexTokenizerFactory(String name) throws IOException {
        Message resp = this.session.rpc("com.logpresso.index.msgbus.ManagementPlugin.getIndexTokenizerFactory");
        return this.parseIndexTokenizerFactory(resp.getParameters().get("factory"));
    }

    private IndexTokenizerFactoryInfo parseIndexTokenizerFactory(Object o) {
        Map m = (Map)o;
        IndexTokenizerFactoryInfo f = new IndexTokenizerFactoryInfo();
        f.setName((String)m.get("name"));
        f.setConfigSpecs(this.parseIndexConfigList((List)m.get("config_specs")));
        return f;
    }

    private List<IndexConfigSpec> parseIndexConfigList(List<Object> l) {
        ArrayList<IndexConfigSpec> specs = new ArrayList<IndexConfigSpec>();
        for (Object o : l) {
            Map m = (Map)o;
            IndexConfigSpec spec = new IndexConfigSpec();
            spec.setKey((String)m.get("key"));
            spec.setName((String)m.get("name"));
            spec.setDescription((String)m.get("description"));
            spec.setRequired((Boolean)m.get("required"));
            specs.add(spec);
        }
        return specs;
    }

    public List<IndexInfo> listIndexes(String tableName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", tableName);
        Message resp = this.session.rpc("com.logpresso.index.msgbus.ManagementPlugin.listIndexes", params);
        ArrayList<IndexInfo> indexes = new ArrayList<IndexInfo>();
        List l = (List)resp.getParameters().get("indexes");
        for (Object o : l) {
            Map m = (Map)o;
            IndexInfo indexInfo = this.getIndexInfo(m);
            indexes.add(indexInfo);
        }
        return indexes;
    }

    public IndexInfo getIndexInfo(String tableName, String indexName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", tableName);
        params.put("index", indexName);
        Message resp = this.session.rpc("com.logpresso.index.msgbus.ManagementPlugin.getIndexInfo", params);
        return this.getIndexInfo((Map)resp.getParameters().get("index"));
    }

    private IndexInfo getIndexInfo(Map<String, Object> m) {
        IndexInfo index = new IndexInfo();
        index.setTableName((String)m.get("table"));
        index.setIndexName((String)m.get("index"));
        index.setTokenizerName((String)m.get("tokenizer_name"));
        index.setTokenizerConfigs((Map)m.get("tokenizer_configs"));
        try {
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
            String s = (String)m.get("min_index_day");
            if (s != null) {
                index.setMinIndexDay(f.parse(s));
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        index.setBasePath((String)m.get("base_path"));
        index.setBuildPastIndex((Boolean)m.get("build_past_index"));
        return index;
    }

    public void createIndex(IndexInfo info) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", info.getTableName());
        params.put("index", info.getIndexName());
        params.put("tokenizer_name", info.getTokenizerName());
        params.put("tokenizer_configs", info.getTokenizerConfigs());
        params.put("base_path", info.getBasePath());
        params.put("min_index_day", info.getMinIndexDay());
        params.put("build_past_index", info.isBuildPastIndex());
        this.session.rpc("com.logpresso.index.msgbus.ManagementPlugin.createIndex", params);
    }

    public void dropIndex(String tableName, String indexName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", tableName);
        params.put("index", indexName);
        this.session.rpc("com.logpresso.index.msgbus.ManagementPlugin.dropIndex", params);
    }

    public List<TableSchemaInfo> listTables() throws IOException {
        Message resp = this.session.rpc("org.araqne.logdb.msgbus.ManagementPlugin.listTables");
        ArrayList<TableSchemaInfo> tables = new ArrayList<TableSchemaInfo>();
        Map m = (Map)resp.getParameters().get("tables");
        for (String tableName : m.keySet()) {
            Map params = (Map)m.get(tableName);
            TableSchemaInfo tableInfo = this.getTableInfo(tableName, params);
            tables.add(tableInfo);
        }
        return tables;
    }

    public TableSchemaInfo getTableInfo(String tableName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", tableName);
        Message resp = this.session.rpc("org.araqne.logdb.msgbus.ManagementPlugin.getTableInfo", params);
        return this.getTableInfo(tableName, (Map)resp.get("table"));
    }

    private TableSchemaInfo getTableInfo(String tableName, Map<String, Object> params) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (Map.Entry<String, Object> pair : params.entrySet()) {
            metadata.put(pair.getKey(), pair.getValue() == null ? null : pair.getValue().toString());
        }
        return new TableSchemaInfo(tableName, metadata);
    }

    public void setTableMetadata(String tableName, Map<String, String> config) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", tableName);
        params.put("metadata", config);
        this.session.rpc("org.araqne.logdb.msgbus.ManagementPlugin.setTableMetadata", params);
    }

    public void unsetTableMetadata(String tableName, Set<String> keySet) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", tableName);
        params.put("keys", keySet);
        this.session.rpc("org.araqne.logdb.msgbus.ManagementPlugin.unsetTableMetadata", params);
    }

    public void createTable(String tableName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", tableName);
        this.session.rpc("org.araqne.logdb.msgbus.ManagementPlugin.createTable", params);
    }

    public void dropTable(String tableName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", tableName);
        this.session.rpc("org.araqne.logdb.msgbus.ManagementPlugin.dropTable", params);
    }

    public List<LoggerFactoryInfo> listLoggerFactories() throws IOException {
        Message resp = this.session.rpc("org.araqne.log.api.msgbus.LoggerPlugin.getLoggerFactories");
        ArrayList<LoggerFactoryInfo> factories = new ArrayList<LoggerFactoryInfo>();
        List l = (List)resp.get("factories");
        for (Object o : l) {
            this.parseLoggerFactoryInfo(factories, o);
        }
        return factories;
    }

    public LoggerFactoryInfo getLoggerFactoryInfo(String factoryName) throws IOException {
        List<LoggerFactoryInfo> factories = this.listLoggerFactories();
        LoggerFactoryInfo found = null;
        for (LoggerFactoryInfo f : factories) {
            if (!f.getNamespace().equals("local") || !f.getName().equals(factoryName)) continue;
            found = f;
            break;
        }
        if (found == null) {
            throw new IllegalStateException("logger factory not found: " + factoryName);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("factory", factoryName);
        Message resp2 = this.session.rpc("org.araqne.log.api.msgbus.LoggerPlugin.getFactoryOptions", params);
        List<ConfigSpec> configSpecs = this.parseConfigList((List)resp2.get("options"));
        found.setConfigSpecs(configSpecs);
        return found;
    }

    private void parseLoggerFactoryInfo(List<LoggerFactoryInfo> factories, Object o) {
        Map m = (Map)o;
        LoggerFactoryInfo f = new LoggerFactoryInfo();
        f.setFullName((String)m.get("full_name"));
        f.setDisplayName((String)m.get("display_name"));
        f.setNamespace((String)m.get("namespace"));
        f.setName((String)m.get("name"));
        f.setDescription((String)m.get("description"));
        factories.add(f);
    }

    public List<ParserFactoryInfo> listParserFactories() throws IOException {
        Message resp = this.session.rpc("org.araqne.log.api.msgbus.LoggerPlugin.getParserFactories");
        List l = (List)resp.get("factories");
        ArrayList<ParserFactoryInfo> parsers = new ArrayList<ParserFactoryInfo>();
        for (Object o : l) {
            Map m = (Map)o;
            ParserFactoryInfo f = new ParserFactoryInfo();
            f.setName((String)m.get("name"));
            f.setDisplayName((String)m.get("display_name"));
            f.setDescription((String)m.get("description"));
            f.setConfigSpecs(this.parseConfigList((List)m.get("options")));
            parsers.add(f);
        }
        return parsers;
    }

    private List<ConfigSpec> parseConfigList(List<Object> l) {
        ArrayList<ConfigSpec> specs = new ArrayList<ConfigSpec>();
        for (Object o : l) {
            Map m = (Map)o;
            ConfigSpec spec = new ConfigSpec();
            spec.setName((String)m.get("name"));
            spec.setDescription((String)m.get("description"));
            spec.setDisplayName((String)m.get("display_name"));
            spec.setType((String)m.get("type"));
            spec.setRequired((Boolean)m.get("required"));
            spec.setDefaultValue((String)m.get("default_value"));
            specs.add(spec);
        }
        return specs;
    }

    public List<LoggerInfo> listLoggers() throws IOException {
        Message resp = this.session.rpc("org.araqne.log.api.msgbus.LoggerPlugin.getLoggers");
        List l = (List)resp.get("loggers");
        ArrayList<LoggerInfo> loggers = new ArrayList<LoggerInfo>();
        for (Object o : l) {
            Map m = (Map)o;
            LoggerInfo lo = new LoggerInfo();
            lo.setNamespace((String)m.get("namespace"));
            lo.setName((String)m.get("name"));
            lo.setFactoryName((String)m.get("factory_full_name"));
            lo.setDescription((String)m.get("description"));
            lo.setPassive((Boolean)m.get("is_passive"));
            lo.setInterval((Integer)m.get("interval"));
            lo.setStatus((String)m.get("status"));
            lo.setLastStartAt(this.parseDate((String)m.get("last_start")));
            lo.setLastRunAt(this.parseDate((String)m.get("last_run")));
            lo.setLastLogAt(this.parseDate((String)m.get("last_log")));
            lo.setLogCount(Long.valueOf(m.get("log_count").toString()));
            loggers.add(lo);
        }
        return loggers;
    }

    private Date parseDate(String s) {
        if (s == null) {
            return null;
        }
        try {
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
            return f.parse(s);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void createLogger(LoggerInfo logger) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("factory", logger.getFactoryName());
        params.put("namespace", logger.getNamespace());
        params.put("name", logger.getName());
        params.put("description", logger.getDescription());
        params.put("options", logger.getConfigs());
        this.session.rpc("org.araqne.log.api.msgbus.LoggerPlugin.createLogger", params);
    }

    public void removeLogger(String fullName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("logger", fullName);
        this.session.rpc("org.araqne.log.api.msgbus.LoggerPlugin.removeLogger", params);
    }

    public void startLogger(String fullName, int interval) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("logger", fullName);
        params.put("interval", interval);
        this.session.rpc("org.araqne.log.api.msgbus.LoggerPlugin.startLogger", params);
    }

    public void stopLogger(String fullName, int waitTime) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("logger", fullName);
        params.put("wait_time", waitTime);
        this.session.rpc("org.araqne.log.api.msgbus.LoggerPlugin.stopLogger", params);
    }

    public LogCursor query(String queryString) throws IOException {
        int id = this.createQuery(queryString);
        this.startQuery(id);
        LogQuery q = this.queries.get(id);
        q.waitUntil(null);
        long total = q.getLoadedCount();
        return new LogCursorImpl(id, 0L, total, true);
    }

    public int createQuery(String queryString) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("query", queryString);
        Message resp = this.session.rpc("org.araqne.logdb.msgbus.LogQueryPlugin.createQuery", params);
        int id = resp.getInt("id");
        this.session.registerTrap("logstorage-query-" + id);
        this.session.registerTrap("logstorage-query-timeline-" + id);
        this.queries.put(id, new LogQuery(null, id, queryString));
        return id;
    }

    public void startQuery(int id) throws IOException {
        this.startQuery(id, 10, 10);
    }

    public void startQuery(int id, int pageSize, int timelineSize) throws IOException {
        this.verifyQueryId(id);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("offset", 0);
        params.put("limit", pageSize);
        params.put("timeline_limit", timelineSize);
        this.session.rpc("org.araqne.logdb.msgbus.LogQueryPlugin.startQuery", params);
    }

    public void stopQuery(int id) throws IOException {
        this.verifyQueryId(id);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        this.session.rpc("org.araqne.logdb.msgbus.LogQueryPlugin.stopQuery", params);
    }

    public void removeQuery(int id) throws IOException {
        this.verifyQueryId(id);
        this.session.unregisterTrap("logstorage-query-" + id);
        this.session.unregisterTrap("logstorage-query-timeline-" + id);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        this.session.rpc("org.araqne.logdb.msgbus.LogQueryPlugin.removeQuery", params);
        this.queries.remove(id);
    }

    public void waitUntil(int id, Long count) {
        this.verifyQueryId(id);
        this.queries.get(id).waitUntil(count);
    }

    public Map<String, Object> getResult(int id, long offset, int limit) throws IOException {
        this.verifyQueryId(id);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("offset", offset);
        params.put("limit", limit);
        Message resp = this.session.rpc("org.araqne.logdb.msgbus.LogQueryPlugin.getResult", params);
        if (resp.getParameters().size() == 0) {
            throw new MessageException("query-not-found", "", resp.getParameters());
        }
        return resp.getParameters();
    }

    private void verifyQueryId(int id) {
        if (!this.queries.containsKey(id)) {
            throw new MessageException("query-not-found", "query [" + id + "] does not exist", null);
        }
    }

    public void close() throws IOException {
        if (this.session != null) {
            this.session.close();
        }
    }

    @Override
    public void onTrap(Message msg) {
        String method;
        long stamp = 0L;
        if (msg.containsKey("stamp")) {
            stamp = Long.parseLong(msg.get("stamp").toString());
        }
        if ((method = msg.getMethod()).startsWith("logstorage-query-") || method.startsWith("logdb-query-")) {
            int id = msg.getInt("id");
            LogQuery q = this.queries.get(id);
            if (msg.getString("type").equals("eof")) {
                q.updateCount(msg.getLong("total_count"), stamp);
                q.updateStatus("Ended", stamp);
            } else if (msg.getString("type").equals("page_loaded")) {
                q.updateCount(msg.getLong("count"), stamp);
                q.updateStatus("Running", stamp);
            } else if (msg.getString("type").equals("status_change")) {
                q.updateCount(msg.getLong("count"), stamp);
                q.updateStatus(msg.getString("status"), stamp);
            }
        }
    }

    @Override
    public void onClose(Throwable t) {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class LogCursorImpl
    implements LogCursor {
        private int id;
        private long offset;
        private long limit;
        private boolean removeOnClose;
        private long p;
        private Map<String, Object> cached;
        private Long currentCacheOffset;
        private Long nextCacheOffset;
        private int fetchUnit;
        private Map<String, Object> prefetch;

        public LogCursorImpl(int id, long offset, long limit, boolean removeOnClose) {
            this.id = id;
            this.offset = offset;
            this.limit = limit;
            this.removeOnClose = removeOnClose;
            this.p = offset;
            this.nextCacheOffset = offset;
            this.fetchUnit = 1000;
        }

        @Override
        public boolean hasNext() {
            if (this.prefetch != null) {
                return true;
            }
            if (this.p < this.offset || this.p >= this.offset + this.limit) {
                return false;
            }
            try {
                List l;
                int relative;
                if (this.cached == null || this.p >= this.currentCacheOffset + (long)this.fetchUnit) {
                    this.cached = CometClient.this.getResult(this.id, this.nextCacheOffset, this.fetchUnit);
                    this.currentCacheOffset = this.nextCacheOffset;
                    this.nextCacheOffset = this.nextCacheOffset + (long)this.fetchUnit;
                }
                if ((relative = (int)(this.p - this.currentCacheOffset)) >= (l = (List)this.cached.get("result")).size()) {
                    return false;
                }
                this.prefetch = (Map)l.get(relative);
                ++this.p;
                return true;
            }
            catch (IOException e) {
                CometClient.this.logger.error("araqne logdb client: cannot fetch log query result", e);
                return false;
            }
        }

        @Override
        public Map<String, Object> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("end of log cursor");
            }
            Map<String, Object> m = this.prefetch;
            this.prefetch = null;
            return m;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            if (this.removeOnClose) {
                CometClient.this.removeQuery(this.id);
            }
        }
    }
}

