/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.logdb.client;

import java.util.List;
import org.araqne.logdb.client.StorageEngineConfigSpec;

public class StorageEngineInfo {
    private String name;
    private List<StorageEngineConfigSpec> primaryConfigSpecs;
    private List<StorageEngineConfigSpec> replicaConfigSpecs;

    public StorageEngineInfo(String name, List<StorageEngineConfigSpec> primaryConfigSpecs, List<StorageEngineConfigSpec> replicaConfigSpecs) {
        this.name = name;
        this.primaryConfigSpecs = primaryConfigSpecs;
        this.replicaConfigSpecs = replicaConfigSpecs;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<StorageEngineConfigSpec> getPrimaryConfigSpecs() {
        return this.primaryConfigSpecs;
    }

    public void setPrimaryConfigSpecs(List<StorageEngineConfigSpec> primaryConfigSpecs) {
        this.primaryConfigSpecs = primaryConfigSpecs;
    }

    public List<StorageEngineConfigSpec> getReplicaConfigSpecs() {
        return this.replicaConfigSpecs;
    }

    public void setReplicaConfigSpecs(List<StorageEngineConfigSpec> replicaConfigSpecs) {
        this.replicaConfigSpecs = replicaConfigSpecs;
    }

    public String toString() {
        String s = "name=" + this.name;
        s = s + ", primary options={";
        int i = 0;
        for (StorageEngineConfigSpec spec : this.primaryConfigSpecs) {
            if (i++ != 0) {
                s = s + ", ";
            }
            s = s + spec.getDisplayName();
            if (spec.getDescription() == null) continue;
            s = s + ": " + spec.getDescription();
        }
        s = s + "}";
        i = 0;
        if (this.replicaConfigSpecs != null && !this.replicaConfigSpecs.isEmpty()) {
            s = s + ", replica options={";
            for (StorageEngineConfigSpec spec : this.replicaConfigSpecs) {
                if (i++ != 0) {
                    s = s + ", ";
                }
                s = s + spec.getDisplayName();
                if (spec.getDescription() == null) continue;
                s = s + ": " + spec.getDescription();
            }
            s = s + "}";
        }
        return s;
    }
}

