/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.logdb.client;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.araqne.api.DateFormat;

public class LoggerInfo {
    private String factoryName;
    private String namespace;
    private String name;
    private String description;
    private boolean passive;
    private int interval;
    private String startTime;
    private String endTime;
    private String status;
    private Date lastStartAt;
    private Date lastRunAt;
    private Date lastLogAt;
    private long logCount;
    private long dropCount;
    private long updateCount;
    private Map<String, String> configs = new HashMap<String, String>();
    private Map<String, Object> states = new HashMap<String, Object>();

    public String getFactoryName() {
        return this.factoryName;
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }

    public String getFullName() {
        return this.namespace + "\\" + this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, String> getConfigs() {
        return this.configs;
    }

    public void setConfigs(Map<String, String> configs) {
        this.configs = configs;
    }

    public Map<String, Object> getStates() {
        return this.states;
    }

    public void setStates(Map<String, Object> states) {
        this.states = states;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getLastStartAt() {
        return this.lastStartAt;
    }

    public void setLastStartAt(Date lastStartAt) {
        this.lastStartAt = lastStartAt;
    }

    public Date getLastRunAt() {
        return this.lastRunAt;
    }

    public void setLastRunAt(Date lastRunAt) {
        this.lastRunAt = lastRunAt;
    }

    public Date getLastLogAt() {
        return this.lastLogAt;
    }

    public void setLastLogAt(Date lastLogAt) {
        this.lastLogAt = lastLogAt;
    }

    public long getLogCount() {
        return this.logCount;
    }

    public void setLogCount(long logCount) {
        this.logCount = logCount;
    }

    public long getDropCount() {
        return this.dropCount;
    }

    public void setDropCount(long dropCount) {
        this.dropCount = dropCount;
    }

    public long getUpdateCount() {
        return this.updateCount;
    }

    public void setUpdateCount(long updateCount) {
        this.updateCount = updateCount;
    }

    public String toString() {
        String format = "yyyy-MM-dd HH:mm:ss";
        String start = DateFormat.format(format, this.lastStartAt);
        String run = DateFormat.format(format, this.lastRunAt);
        String log = DateFormat.format(format, this.lastLogAt);
        String status = this.getStatus().toString().toLowerCase();
        status = this.passive ? status + " (passive)" : status + " (interval=" + this.interval + "ms)";
        String details = "";
        if (this.configs != null && this.configs.size() > 0) {
            details = details + ", configs=" + this.configs;
        }
        if (this.states != null && this.states.size() > 0) {
            details = details + ", states=" + this.states;
        }
        return String.format("name=%s, factory=%s, status=%s, log count=%d, last start=%s, last run=%s, last log=%s" + details, this.getFullName(), this.factoryName, status, this.getLogCount(), start, run, log);
    }
}

