/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.logdb.client;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.araqne.api.PrimitiveConverter;
import org.araqne.codec.EncodingRule;
import org.araqne.logdb.client.AccountInfo;
import org.araqne.logdb.client.ArchiveConfig;
import org.araqne.logdb.client.ConfigSpec;
import org.araqne.logdb.client.FailureListener;
import org.araqne.logdb.client.FieldInfo;
import org.araqne.logdb.client.IndexConfigSpec;
import org.araqne.logdb.client.IndexInfo;
import org.araqne.logdb.client.IndexTokenizerFactoryInfo;
import org.araqne.logdb.client.JdbcProfileInfo;
import org.araqne.logdb.client.LogCursor;
import org.araqne.logdb.client.LogDbSession;
import org.araqne.logdb.client.LogDbTransport;
import org.araqne.logdb.client.LogQuery;
import org.araqne.logdb.client.LogQueryCommand;
import org.araqne.logdb.client.LoggerFactoryInfo;
import org.araqne.logdb.client.LoggerInfo;
import org.araqne.logdb.client.Message;
import org.araqne.logdb.client.MessageException;
import org.araqne.logdb.client.ParserFactoryInfo;
import org.araqne.logdb.client.ParserInfo;
import org.araqne.logdb.client.PeerStatus;
import org.araqne.logdb.client.Privilege;
import org.araqne.logdb.client.Row;
import org.araqne.logdb.client.ScheduledQueryInfo;
import org.araqne.logdb.client.StorageEngineConfig;
import org.araqne.logdb.client.StorageEngineConfigSpec;
import org.araqne.logdb.client.StorageEngineInfo;
import org.araqne.logdb.client.StreamQueryInfo;
import org.araqne.logdb.client.StreamQueryStatus;
import org.araqne.logdb.client.StreamingResultSet;
import org.araqne.logdb.client.SubQuery;
import org.araqne.logdb.client.TableConfig;
import org.araqne.logdb.client.TableSchemaInfo;
import org.araqne.logdb.client.TransformerFactoryInfo;
import org.araqne.logdb.client.TransformerInfo;
import org.araqne.logdb.client.http.WebSocketTransport;
import org.araqne.logdb.client.http.impl.StreamingResultDecoder;
import org.araqne.logdb.client.http.impl.StreamingResultEncoder;
import org.araqne.logdb.client.http.impl.TrapListener;
import org.araqne.websocket.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogDbClient
implements TrapListener,
Closeable {
    private Logger logger = LoggerFactory.getLogger(LogDbClient.class);
    private LogDbTransport transport;
    private LogDbSession session;
    private int fetchSize = 10000;
    private ConcurrentMap<Integer, LogQuery> queries = new ConcurrentHashMap<Integer, LogQuery>();
    private ConcurrentMap<Integer, StreamingResultSet> streamCallbacks = new ConcurrentHashMap<Integer, StreamingResultSet>();
    private Locale locale = Locale.getDefault();
    private StreamingResultDecoder streamingDecoder;
    private AtomicReference<Flusher> flusher = new AtomicReference<Object>(null);
    private StreamingResultEncoder streamingEncoder;
    private int counter = 0;
    private int insertBatchSize = 5000;
    private int indexFlushInterval = 1000;
    private Map<String, List<QueuedRows>> flushBuffers = new HashMap<String, List<QueuedRows>>();
    private CopyOnWriteArraySet<FailureListener> failureListeners = new CopyOnWriteArraySet();

    public LogDbClient() {
        this(new WebSocketTransport());
    }

    public LogDbClient(LogDbTransport transport) {
        this.transport = transport;
        int poolSize = Math.min(8, Runtime.getRuntime().availableProcessors());
        this.streamingDecoder = new StreamingResultDecoder("Streaming Result Decoder", poolSize);
        this.streamingEncoder = new StreamingResultEncoder("Streaming Result Incoder", poolSize);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.checkNotNull("locale", locale);
        this.locale = locale;
    }

    public LogDbSession getSession() {
        return this.session;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getInsertFetchSize() {
        return this.insertBatchSize;
    }

    public void setInserFetchSize(int insertFetchSize) {
        if (insertFetchSize < 0 || insertFetchSize > 200000) {
            throw new IllegalArgumentException("InsertFetchSize should be > 0 and < 200000");
        }
        this.insertBatchSize = insertFetchSize;
    }

    public int getIndexFlushInterval() {
        return this.indexFlushInterval;
    }

    public void setIndexFlushInterval(int millisec) {
        if (millisec < 0) {
            throw new IllegalArgumentException("Index flush interval should be greater than 0");
        }
        this.indexFlushInterval = millisec;
        if (this.flusher.get() != null) {
            this.flusher.get().signal();
        }
    }

    public boolean isClosed() {
        return this.session == null || this.session.isClosed();
    }

    public List<LogQuery> getQueries() throws IOException {
        Message resp = this.rpc("org.araqne.logdb.msgbus.LogQueryPlugin.queries");
        List l = (List)resp.getParameters().get("queries");
        for (Map q : l) {
            int queryId = (Integer)q.get("id");
            LogQuery query = (LogQuery)this.queries.get(queryId);
            if (query == null) {
                query = new LogQuery(this, queryId, (String)q.get("query_string"));
                LogQuery old = this.queries.putIfAbsent(queryId, query);
                if (old != null) {
                    query = old;
                }
            }
            this.parseQueryStatus(q, query);
        }
        return new ArrayList<LogQuery>(this.queries.values());
    }

    public LogQuery getQuery(int id) throws IOException {
        block4: {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", id);
            try {
                Message resp = this.rpc("org.araqne.logdb.msgbus.LogQueryPlugin.queryStatus", params);
                Map<String, Object> q = resp.getParameters();
                int queryId = (Integer)q.get("id");
                LogQuery query = (LogQuery)this.queries.get(queryId);
                if (query == null) {
                    query = new LogQuery(this, queryId, (String)q.get("query_string"));
                    LogQuery old = this.queries.putIfAbsent(queryId, query);
                    if (old != null) {
                        query = old;
                    }
                }
                this.parseQueryStatus(q, query);
            }
            catch (MessageException t) {
                if (t.getMessage().startsWith("msgbus-handler-not-found")) break block4;
                throw t;
            }
        }
        return (LogQuery)this.queries.get(id);
    }

    private void parseQueryStatus(Map<String, Object> q, LogQuery query) {
        List subQueries;
        boolean end;
        ArrayList<LogQueryCommand> commands = new ArrayList<LogQueryCommand>();
        List cl = (List)q.get("commands");
        for (Map cm : cl) {
            commands.add(this.parseCommand(cm));
        }
        long stamp = 0L;
        if (q.containsKey("stamp")) {
            stamp = Long.parseLong(q.get("stamp").toString());
        }
        query.setCommands(commands);
        boolean eof = end = ((Boolean)q.get("is_end")).booleanValue();
        if (q.containsKey("is_eof")) {
            eof = (Boolean)q.get("is_eof");
        }
        boolean cancelled = false;
        if (q.containsKey("is_cancelled")) {
            cancelled = (Boolean)q.get("is_cancelled");
        }
        if (eof) {
            if (!query.getCommands().get(0).getStatus().equalsIgnoreCase("Waiting")) {
                query.updateStatus("Ended", stamp);
            }
            if (cancelled) {
                query.updateStatus("Cancelled", stamp);
            }
        } else if (end) {
            query.updateStatus("Stopped", stamp);
        } else {
            query.updateStatus("Running", stamp);
        }
        if (q.containsKey("background")) {
            query.setBackground((Boolean)q.get("background"));
        }
        query.setElapsed(this.toLong(q.get("elapsed")));
        Long startTime = this.toLong(q.get("start_time"));
        Long finishTime = this.toLong(q.get("finish_time"));
        if (startTime != null && startTime != 0L) {
            query.setStartTime(new Date(startTime));
        }
        if (finishTime != null && finishTime != 0L) {
            query.setFinishTime(new Date(finishTime));
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
        if (q.get("last_started") != null) {
            query.setLastStarted(df.parse((String)q.get("last_started"), new ParsePosition(0)));
        }
        if ((subQueries = (List)q.get("sub_queries")) != null) {
            for (Object o : subQueries) {
                SubQuery subQuery = this.parseSubQuery((Map)o);
                query.getSubQueries().add(subQuery);
            }
        }
    }

    private SubQuery parseSubQuery(Map<String, Object> m) {
        SubQuery q = new SubQuery();
        q.setId((Integer)m.get("id"));
        List l = (List)m.get("commands");
        if (l != null) {
            for (Object o : l) {
                q.getCommands().add(this.parseCommand((Map)o));
            }
        }
        return q;
    }

    private LogQueryCommand parseCommand(Map<String, Object> m) {
        LogQueryCommand c = new LogQueryCommand();
        c.setName((String)m.get("name"));
        c.setStatus((String)m.get("status"));
        c.setPushCount(this.toLong(m.get("push_count")));
        c.setCommand((String)m.get("command"));
        List l = (List)m.get("commands");
        if (l != null) {
            for (Object o : l) {
                c.getCommands().add(this.parseCommand((Map)o));
            }
        }
        return c;
    }

    private Long toLong(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof Integer) {
            return (long)((Integer)v);
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        return null;
    }

    public void connect(String host, String loginName, String password) throws IOException {
        this.connect(host, 8888, loginName, password);
    }

    public void connect(String host, int port, String loginName, String password) throws IOException {
        this.connect(host, port, loginName, password, 0, 10000);
    }

    public void connect(String host, int port, String loginName, String password, int connectTimeout) throws IOException {
        this.connect(host, port, loginName, password, connectTimeout, 10000);
    }

    public void connect(String host, int port, String loginName, String password, int connectTimeout, int readTimeout) throws IOException {
        this.session = this.transport.newSession(host, port, connectTimeout, readTimeout);
        try {
            this.session.login(loginName, password, true);
            this.session.addListener(this);
        }
        catch (IOException e) {
            this.session.close();
            this.session = null;
            throw e;
        }
        catch (Throwable t) {
            this.session.close();
            this.session = null;
            throw new IllegalStateException(t);
        }
    }

    public List<ArchiveConfig> listArchiveConfigs() throws IOException {
        ArrayList<ArchiveConfig> configs = new ArrayList<ArchiveConfig>();
        Message resp = this.rpc("com.logpresso.core.msgbus.ArchivePlugin.getConfigs");
        List l = (List)resp.get("configs");
        for (Map m : l) {
            configs.add(this.parseArchiveConfig(m));
        }
        return configs;
    }

    public ArchiveConfig getArchiveConfig(String loggerName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("logger", loggerName);
        Message resp = this.rpc("com.logpresso.core.msgbus.ArchivePlugin.getConfig", params);
        Map m = (Map)resp.getParameters().get("config");
        return this.parseArchiveConfig(m);
    }

    private ArchiveConfig parseArchiveConfig(Map<String, Object> m) {
        ArchiveConfig c = new ArchiveConfig();
        c.setLoggerName((String)m.get("logger"));
        c.setTableName((String)m.get("table"));
        c.setHost((String)m.get("host"));
        c.setPrimaryLogger((String)m.get("primary_logger"));
        c.setBackupLogger((String)m.get("backup_logger"));
        c.setEnabled((Boolean)m.get("enabled"));
        c.setMetadata((Map)m.get("metadata"));
        return c;
    }

    public void createArchiveConfig(ArchiveConfig config) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("logger", config.getLoggerName());
        params.put("table", config.getTableName());
        params.put("host", config.getHost());
        params.put("enabled", config.isEnabled());
        params.put("metadata", config.getMetadata());
        this.rpc("com.logpresso.core.msgbus.ArchivePlugin.createConfig", params);
    }

    public void removeArchiveConfig(String loggerName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("logger", loggerName);
        this.rpc("com.logpresso.core.msgbus.ArchivePlugin.removeConfig", params);
    }

    public List<AccountInfo> listAccounts() throws IOException {
        Message resp = this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.listAccounts");
        ArrayList<AccountInfo> accounts = new ArrayList<AccountInfo>();
        List l = (List)resp.get("accounts");
        for (Object o : l) {
            Map m = (Map)o;
            List pl = (List)m.get("privileges");
            AccountInfo account = new AccountInfo();
            String loginName = (String)m.get("login_name");
            account.setLoginName(loginName);
            for (Object o2 : pl) {
                Map m2 = (Map)o2;
                String tableName = (String)m2.get("table_name");
                Privilege p = new Privilege(loginName, tableName);
                account.getPrivileges().add(p);
            }
            accounts.add(account);
        }
        return accounts;
    }

    public void createAccount(AccountInfo account) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("login_name", account.getLoginName());
        params.put("password", account.getPassword());
        this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.createAccount", params);
    }

    public void removeAccount(String loginName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("login_name", loginName);
        this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.removeAccount", params);
    }

    public void changePassword(String loginName, String password) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("login_name", loginName);
        params.put("password", password);
        this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.changePassword", params);
    }

    public void grantPrivilege(Privilege privilege) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("login_name", privilege.getLoginName());
        params.put("table_name", privilege.getTableName());
        this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.grantPrivilege", params);
    }

    public void revokePrivilege(Privilege privilege) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("login_name", privilege.getLoginName());
        params.put("table_name", privilege.getTableName());
        this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.revokePrivilege", params);
    }

    public List<IndexTokenizerFactoryInfo> listIndexTokenizerFactories() throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("locale", this.locale.getLanguage());
        Message resp = this.rpc("com.logpresso.index.msgbus.ManagementPlugin.listIndexTokenizerFactories", params);
        ArrayList<IndexTokenizerFactoryInfo> l = new ArrayList<IndexTokenizerFactoryInfo>();
        for (Object o : (List)resp.getParameters().get("factories")) {
            IndexTokenizerFactoryInfo f = this.parseIndexTokenizerFactory(o);
            l.add(f);
        }
        return l;
    }

    public IndexTokenizerFactoryInfo getIndexTokenizerFactory(String name) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        params.put("locale", this.locale.getLanguage());
        Message resp = this.rpc("com.logpresso.index.msgbus.ManagementPlugin.getIndexTokenizerFactoryInfo", params);
        return this.parseIndexTokenizerFactory(resp.getParameters().get("factory"));
    }

    private IndexTokenizerFactoryInfo parseIndexTokenizerFactory(Object o) {
        Map m = (Map)o;
        IndexTokenizerFactoryInfo f = new IndexTokenizerFactoryInfo();
        f.setName((String)m.get("name"));
        f.setConfigSpecs(this.parseIndexConfigList((List)m.get("config_specs")));
        return f;
    }

    private List<IndexConfigSpec> parseIndexConfigList(List<Object> l) {
        ArrayList<IndexConfigSpec> specs = new ArrayList<IndexConfigSpec>();
        for (Object o : l) {
            Map m = (Map)o;
            IndexConfigSpec spec = new IndexConfigSpec();
            spec.setKey((String)m.get("key"));
            spec.setName((String)m.get("name"));
            spec.setDescription((String)m.get("description"));
            spec.setRequired((Boolean)m.get("required"));
            specs.add(spec);
        }
        return specs;
    }

    public List<IndexInfo> listIndexes(String tableName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", tableName);
        Message resp = this.rpc("com.logpresso.index.msgbus.ManagementPlugin.listIndexes", params);
        ArrayList<IndexInfo> indexes = new ArrayList<IndexInfo>();
        List l = (List)resp.getParameters().get("indexes");
        for (Object o : l) {
            Map m = (Map)o;
            IndexInfo indexInfo = this.getIndexInfo(m);
            indexes.add(indexInfo);
        }
        return indexes;
    }

    public IndexInfo getIndexInfo(String tableName, String indexName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", tableName);
        params.put("index", indexName);
        Message resp = this.rpc("com.logpresso.index.msgbus.ManagementPlugin.getIndexInfo", params);
        return this.getIndexInfo((Map)resp.getParameters().get("index"));
    }

    public Set<String> testIndexTokenizer(String tableName, String indexName, Map<String, Object> data) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", tableName);
        params.put("index", indexName);
        params.put("data", data);
        Message resp = this.rpc("com.logpresso.index.msgbus.ManagementPlugin.testIndexTokenizer", params);
        return new HashSet<String>((List)resp.getParameters().get("tokens"));
    }

    private IndexInfo getIndexInfo(Map<String, Object> m) {
        IndexInfo index = new IndexInfo();
        index.setTableName((String)m.get("table"));
        index.setIndexName((String)m.get("index"));
        index.setTokenizerName((String)m.get("tokenizer_name"));
        index.setTokenizerConfigs((Map)m.get("tokenizer_configs"));
        try {
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
            String s = (String)m.get("min_index_day");
            if (s != null) {
                index.setMinIndexDay(f.parse(s));
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        index.setUseBloomFilter((Boolean)m.get("use_bloom_filter"));
        index.setBloomFilterCapacity0((Integer)m.get("bf_lv0_capacity"));
        index.setBloomFilterErrorRate0((Double)m.get("bf_lv0_error_rate"));
        index.setBloomFilterCapacity1((Integer)m.get("bf_lv1_capacity"));
        index.setBloomFilterErrorRate1((Double)m.get("bf_lv1_error_rate"));
        index.setBasePath((String)m.get("base_path"));
        index.setBuildPastIndex((Boolean)m.get("build_past_index"));
        return index;
    }

    public void createIndex(IndexInfo info) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", info.getTableName());
        params.put("index", info.getIndexName());
        params.put("tokenizer_name", info.getTokenizerName());
        params.put("tokenizer_configs", info.getTokenizerConfigs());
        params.put("base_path", info.getBasePath());
        params.put("use_bloom_filter", info.isUseBloomFilter());
        params.put("bf_lv0_capacity", info.getBloomFilterCapacity0());
        params.put("bf_lv0_error_rate", info.getBloomFilterErrorRate0());
        params.put("bf_lv1_capacity", info.getBloomFilterCapacity1());
        params.put("bf_lv1_error_rate", info.getBloomFilterErrorRate1());
        params.put("min_index_day", info.getMinIndexDay());
        params.put("build_past_index", info.isBuildPastIndex());
        this.rpc("com.logpresso.index.msgbus.ManagementPlugin.createIndex", params);
    }

    public void dropIndex(String tableName, String indexName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", tableName);
        params.put("index", indexName);
        this.rpc("com.logpresso.index.msgbus.ManagementPlugin.dropIndex", params);
    }

    public List<TableSchemaInfo> listTables() throws IOException {
        Message resp = this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.listTables");
        ArrayList<TableSchemaInfo> tables = new ArrayList<TableSchemaInfo>();
        Map schemaMap = (Map)resp.get("schemas");
        if (schemaMap != null) {
            for (String tableName : schemaMap.keySet()) {
                Map schema = (Map)schemaMap.get(tableName);
                tables.add(this.parseSchema(schema));
            }
        } else {
            Map metadataMap = (Map)resp.get("tables");
            Map fieldsMap = (Map)resp.get("fields");
            for (String tableName : metadataMap.keySet()) {
                Map params = (Map)metadataMap.get(tableName);
                List fields = (List)fieldsMap.get(tableName);
                TableSchemaInfo tableInfo = this.getTableInfo(tableName, params, fields);
                tables.add(tableInfo);
            }
        }
        return tables;
    }

    private TableSchemaInfo parseSchema(Map<String, Object> schema) {
        List fieldList;
        TableSchemaInfo s = new TableSchemaInfo();
        s.setName((String)schema.get("name"));
        if (schema.get("id") != null) {
            s.setId((Integer)schema.get("id"));
        }
        s.setMetadata((Map)schema.get("metadata"));
        s.setPrimaryStorage(this.parseStorageConfig((Map)schema.get("primary_storage")));
        s.setReplicaStorage(this.parseStorageConfig((Map)schema.get("replica_storage")));
        List l = (List)schema.get("secondary_storages");
        if (l != null) {
            ArrayList<StorageEngineConfig> secondaryStorages = new ArrayList<StorageEngineConfig>();
            for (Map m : l) {
                secondaryStorages.add(this.parseStorageConfig(m));
            }
            s.setSecondaryStorages(secondaryStorages);
        }
        if ((fieldList = (List)schema.get("fields")) != null) {
            ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
            for (String def : fieldList) {
                fields.add(FieldInfo.parse(def));
            }
            s.setFieldDefinitions(fields);
        }
        return s;
    }

    private StorageEngineConfig parseStorageConfig(Map<String, Object> m) {
        if (m == null) {
            return null;
        }
        ArrayList<TableConfig> configs = new ArrayList<TableConfig>();
        Map configMap = (Map)m.get("configs");
        for (String key : configMap.keySet()) {
            Object o = configMap.get(key);
            if (o instanceof String) {
                configs.add(new TableConfig(key, o.toString()));
                continue;
            }
            TableConfig c = new TableConfig();
            c.setKey(key);
            for (Object s : (List)o) {
                c.getValues().add(s.toString());
            }
            configs.add(c);
        }
        StorageEngineConfig c = new StorageEngineConfig();
        c.setType((String)m.get("type"));
        c.setBasePath((String)m.get("base_path"));
        c.setConfigs(configs);
        return c;
    }

    public TableSchemaInfo getTableInfo(String tableName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", tableName);
        Message resp = this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.getTableInfo", params);
        Map schema = (Map)resp.get("schema");
        if (schema != null) {
            return this.parseSchema(schema);
        }
        return this.getTableInfo(tableName, (Map)resp.get("table"), (List)resp.get("fields"));
    }

    private TableSchemaInfo getTableInfo(String tableName, Map<String, Object> params, List<Object> fields) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (Map.Entry<String, Object> pair : params.entrySet()) {
            metadata.put(pair.getKey(), pair.getValue() == null ? null : pair.getValue().toString());
        }
        ArrayList<FieldInfo> fieldDefs = null;
        if (fields != null) {
            fieldDefs = new ArrayList<FieldInfo>();
            for (Object o : fields) {
                Map m = (Map)o;
                FieldInfo f = new FieldInfo();
                f.setType((String)m.get("type"));
                f.setName((String)m.get("name"));
                f.setLength((Integer)m.get("length"));
                fieldDefs.add(f);
            }
        }
        TableSchemaInfo t = new TableSchemaInfo(tableName, metadata);
        t.setFieldDefinitions(fieldDefs);
        return t;
    }

    public void setTableFields(String tableName, List<FieldInfo> fields) throws IOException {
        if (tableName == null) {
            throw new IllegalArgumentException("table name cannot be null");
        }
        ArrayList l = null;
        if (fields != null) {
            l = new ArrayList();
            for (FieldInfo f : fields) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("name", f.getName());
                m.put("type", f.getType());
                m.put("length", f.getLength());
                l.add(m);
            }
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", tableName);
        params.put("fields", l);
        this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.setTableFields", params);
    }

    public void setTableMetadata(String tableName, Map<String, String> config) throws IOException {
        if (tableName == null) {
            throw new IllegalArgumentException("table name cannot be null");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", tableName);
        params.put("metadata", config);
        this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.setTableMetadata", params);
    }

    public void unsetTableMetadata(String tableName, Set<String> keySet) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", tableName);
        params.put("keys", keySet);
        this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.unsetTableMetadata", params);
    }

    public List<StorageEngineInfo> listStorageEngines() throws IOException {
        Message resp = this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.getStorageEngines");
        ArrayList<StorageEngineInfo> l = new ArrayList<StorageEngineInfo>();
        List engines = (List)resp.get("engines");
        for (Map engine : engines) {
            String name = (String)engine.get("type");
            List<StorageEngineConfigSpec> primaryConfigSpecs = this.parseStorageConfigSpecs((List)engine.get("primary_config_specs"));
            List<StorageEngineConfigSpec> replicaConfigSpecs = this.parseStorageConfigSpecs((List)engine.get("replica_config_specs"));
            l.add(new StorageEngineInfo(name, primaryConfigSpecs, replicaConfigSpecs));
        }
        return l;
    }

    private List<StorageEngineConfigSpec> parseStorageConfigSpecs(List<Object> specs) {
        if (specs == null) {
            return null;
        }
        ArrayList<StorageEngineConfigSpec> l = new ArrayList<StorageEngineConfigSpec>();
        for (Object o : specs) {
            Map m = (Map)o;
            StorageEngineConfigSpec spec = new StorageEngineConfigSpec();
            spec.setKey((String)m.get("key"));
            spec.setType((String)m.get("type"));
            spec.setOptional((Boolean)m.get("optional"));
            spec.setUpdatable((Boolean)m.get("updatable"));
            spec.setDisplayName((String)m.get("display_name"));
            spec.setEnums((String)m.get("enums"));
            l.add(spec);
        }
        return l;
    }

    @Deprecated
    public void createTable(String tableName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", tableName);
        params.put("type", "v3p");
        try {
            this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.createTable", params);
        }
        catch (MessageException e) {
            if (e.getMessage().contains("not supported engine")) {
                params.put("type", "v2");
                this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.createTable", params);
            }
            throw e;
        }
    }

    @Deprecated
    public void createTable(String tableName, Map<String, String> metadata) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", tableName);
        params.put("type", "v3p");
        params.put("metadata", metadata);
        try {
            this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.createTable", params);
        }
        catch (MessageException e) {
            if (e.getMessage().contains("not supported engine")) {
                params.put("type", "v2");
                this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.createTable", params);
            }
            throw e;
        }
    }

    public void createTable(String tableName, String type) throws IOException {
        this.createTable(new TableSchemaInfo(tableName, type));
    }

    public void createTable(TableSchemaInfo schema) throws IOException {
        this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.createTable", schema.toMap());
    }

    public void dropTable(String tableName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", tableName);
        this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.dropTable", params);
    }

    public List<LoggerFactoryInfo> listLoggerFactories() throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("locale", this.locale.getLanguage());
        Message resp = this.rpc("org.araqne.log.api.msgbus.LoggerPlugin.getLoggerFactories", params);
        ArrayList<LoggerFactoryInfo> factories = new ArrayList<LoggerFactoryInfo>();
        List l = (List)resp.get("factories");
        for (Object o : l) {
            this.parseLoggerFactoryInfo(factories, o);
        }
        return factories;
    }

    public LoggerFactoryInfo getLoggerFactoryInfo(String factoryName) throws IOException {
        List<LoggerFactoryInfo> factories = this.listLoggerFactories();
        LoggerFactoryInfo found = null;
        for (LoggerFactoryInfo f : factories) {
            if (!f.getNamespace().equals("local") || !f.getName().equals(factoryName)) continue;
            found = f;
            break;
        }
        if (found == null) {
            throw new IllegalStateException("logger factory not found: " + factoryName);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("factory", factoryName);
        params.put("locale", this.locale.getLanguage());
        Message resp2 = this.rpc("org.araqne.log.api.msgbus.LoggerPlugin.getFactoryOptions", params);
        List<ConfigSpec> configSpecs = this.parseConfigList((List)resp2.get("options"));
        found.setConfigSpecs(configSpecs);
        return found;
    }

    private void parseLoggerFactoryInfo(List<LoggerFactoryInfo> factories, Object o) {
        Map m = (Map)o;
        LoggerFactoryInfo f = new LoggerFactoryInfo();
        f.setFullName((String)m.get("full_name"));
        f.setDisplayName((String)m.get("display_name"));
        f.setNamespace((String)m.get("namespace"));
        f.setName((String)m.get("name"));
        f.setDescription((String)m.get("description"));
        factories.add(f);
    }

    public List<ParserFactoryInfo> listParserFactories() throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("locale", this.locale.getLanguage());
        Message resp = this.rpc("org.araqne.log.api.msgbus.LoggerPlugin.getParserFactories", params);
        List l = (List)resp.get("factories");
        ArrayList<ParserFactoryInfo> parsers = new ArrayList<ParserFactoryInfo>();
        for (Object o : l) {
            Map m = (Map)o;
            ParserFactoryInfo f = new ParserFactoryInfo();
            f.setName((String)m.get("name"));
            f.setDisplayName((String)m.get("display_name"));
            f.setDescription((String)m.get("description"));
            f.setConfigSpecs(this.parseConfigList((List)m.get("options")));
            parsers.add(f);
        }
        return parsers;
    }

    public ParserFactoryInfo getParserFactoryInfo(String name) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("factory_name", name);
        Message resp = this.rpc("com.logpresso.core.msgbus.ParserPlugin.getParserFactoryInfo", params);
        Map m = (Map)resp.get("factory");
        ParserFactoryInfo f = new ParserFactoryInfo();
        f.setName((String)m.get("name"));
        f.setDisplayName((String)m.get("display_name"));
        f.setDescription((String)m.get("description"));
        f.setConfigSpecs(this.parseConfigList((List)m.get("options")));
        return f;
    }

    private List<ConfigSpec> parseConfigList(List<Object> l) {
        ArrayList<ConfigSpec> specs = new ArrayList<ConfigSpec>();
        for (Object o : l) {
            Map m = (Map)o;
            ConfigSpec spec = new ConfigSpec();
            spec.setName((String)m.get("name"));
            spec.setDescription((String)m.get("description"));
            spec.setDisplayName((String)m.get("display_name"));
            spec.setType((String)m.get("type"));
            spec.setRequired((Boolean)m.get("required"));
            spec.setDefaultValue((String)m.get("default_value"));
            specs.add(spec);
        }
        return specs;
    }

    @Deprecated
    public List<ParserInfo> getParsers() throws IOException {
        return this.listParsers();
    }

    public List<ParserInfo> listParsers() throws IOException {
        Message resp = this.rpc("com.logpresso.core.msgbus.ParserPlugin.getParsers");
        List l = (List)resp.get("parsers");
        ArrayList<ParserInfo> parsers = new ArrayList<ParserInfo>();
        for (Object o : l) {
            parsers.add(this.parseParserInfo((Map)o));
        }
        return parsers;
    }

    public ParserInfo getParser(String name) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        Message resp = this.rpc("com.logpresso.core.msgbus.ParserPlugin.getParser", params);
        Map m = (Map)resp.get("parser");
        return this.parseParserInfo(m);
    }

    private ParserInfo parseParserInfo(Map<String, Object> m) {
        ParserInfo p = new ParserInfo();
        p.setName((String)m.get("name"));
        p.setFactoryName((String)m.get("factory_name"));
        p.setConfigs((Map)m.get("configs"));
        if (m.get("fields") != null) {
            ArrayList<FieldInfo> l = new ArrayList<FieldInfo>();
            for (Object o : (List)m.get("fields")) {
                l.add(PrimitiveConverter.parse(FieldInfo.class, o));
            }
            p.setFieldDefinitions(l);
        }
        return p;
    }

    public void createParser(ParserInfo parser) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", parser.getName());
        params.put("factory_name", parser.getFactoryName());
        params.put("configs", parser.getConfigs());
        this.rpc("com.logpresso.core.msgbus.ParserPlugin.createParser", params);
    }

    public void removeParser(String name) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        this.rpc("com.logpresso.core.msgbus.ParserPlugin.removeParser", params);
    }

    public List<Map<String, Object>> testParser(String parserName, Map<String, Object> data) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", parserName);
        params.put("data", data);
        Message resp = this.rpc("com.logpresso.core.msgbus.ParserPlugin.testParser", params);
        return (List)resp.get("rows");
    }

    public List<TransformerFactoryInfo> listTransformerFactories() throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("locale", this.locale.getLanguage());
        Message resp = this.rpc("com.logpresso.core.msgbus.TransformerPlugin.listTransformerFactories", params);
        List l = (List)resp.get("factories");
        ArrayList<TransformerFactoryInfo> factories = new ArrayList<TransformerFactoryInfo>();
        for (Object o : l) {
            Map m = (Map)o;
            TransformerFactoryInfo f = new TransformerFactoryInfo();
            f.setName((String)m.get("name"));
            f.setDisplayName((String)m.get("display_name"));
            f.setDescription((String)m.get("description"));
            f.setConfigSpecs(this.parseConfigList((List)m.get("options")));
            factories.add(f);
        }
        return factories;
    }

    public TransformerFactoryInfo getTransformerFactoryInfo(String name) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("factory_name", name);
        params.put("locale", this.locale.getLanguage());
        Message resp = this.rpc("com.logpresso.core.msgbus.TransformerPlugin.getTransformerFactoryInfo", params);
        Map m = (Map)resp.get("factory");
        TransformerFactoryInfo f = new TransformerFactoryInfo();
        f.setName((String)m.get("name"));
        f.setDisplayName((String)m.get("display_name"));
        f.setDescription((String)m.get("description"));
        f.setConfigSpecs(this.parseConfigList((List)m.get("options")));
        return f;
    }

    @Deprecated
    public List<TransformerInfo> getTransformers() throws IOException {
        return this.listTransformers();
    }

    public List<TransformerInfo> listTransformers() throws IOException {
        Message resp = this.rpc("com.logpresso.core.msgbus.TransformerPlugin.getTransformers");
        List l = (List)resp.get("transformers");
        ArrayList<TransformerInfo> transformers = new ArrayList<TransformerInfo>();
        for (Object o : l) {
            transformers.add(this.parseTransformerInfo((Map)o));
        }
        return transformers;
    }

    public TransformerInfo getTransformer(String name) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        Message resp = this.rpc("com.logpresso.core.msgbus.TransformerPlugin.getTransformer", params);
        Map m = (Map)resp.get("transformer");
        return this.parseTransformerInfo(m);
    }

    private TransformerInfo parseTransformerInfo(Map<String, Object> m) {
        TransformerInfo p = new TransformerInfo();
        p.setName((String)m.get("name"));
        p.setFactoryName((String)m.get("factory_name"));
        p.setConfigs((Map)m.get("configs"));
        return p;
    }

    public void createTransformer(TransformerInfo transformer) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", transformer.getName());
        params.put("factory_name", transformer.getFactoryName());
        params.put("configs", transformer.getConfigs());
        this.rpc("com.logpresso.core.msgbus.TransformerPlugin.createTransformer", params);
    }

    public void removeTransformer(String name) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        this.rpc("com.logpresso.core.msgbus.TransformerPlugin.removeTransformer", params);
    }

    public List<LoggerInfo> listLoggers() throws IOException {
        return this.listLoggers(null);
    }

    public List<LoggerInfo> listLoggers(List<String> loggerNames) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("logger_names", loggerNames);
        Message resp = this.rpc("org.araqne.log.api.msgbus.LoggerPlugin.getLoggers", params);
        List l = (List)resp.get("loggers");
        ArrayList<LoggerInfo> loggers = new ArrayList<LoggerInfo>();
        for (Object o : l) {
            Map m = (Map)o;
            LoggerInfo lo = this.decodeLoggerInfo(m);
            loggers.add(lo);
        }
        return loggers;
    }

    public LoggerInfo getLogger(String loggerName) throws IOException {
        return this.getLogger(loggerName, false);
    }

    public LoggerInfo getLogger(String loggerName, boolean includeStates) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("logger_name", loggerName);
        params.put("include_configs", true);
        params.put("include_states", includeStates);
        Message resp = this.rpc("org.araqne.log.api.msgbus.LoggerPlugin.getLogger", params);
        Map m = (Map)resp.get("logger");
        if (m == null) {
            return null;
        }
        return this.decodeLoggerInfo(m);
    }

    private LoggerInfo decodeLoggerInfo(Map<String, Object> m) {
        Object updateCount;
        LoggerInfo lo = new LoggerInfo();
        lo.setNamespace((String)m.get("namespace"));
        lo.setName((String)m.get("name"));
        lo.setFactoryName((String)m.get("factory_full_name"));
        lo.setDescription((String)m.get("description"));
        lo.setPassive((Boolean)m.get("is_passive"));
        lo.setInterval((Integer)m.get("interval"));
        lo.setStartTime((String)m.get("start_time"));
        lo.setEndTime((String)m.get("end_time"));
        lo.setStatus((String)m.get("status"));
        lo.setLastStartAt(this.parseDate((String)m.get("last_start")));
        lo.setLastRunAt(this.parseDate((String)m.get("last_run")));
        lo.setLastLogAt(this.parseDate((String)m.get("last_log")));
        lo.setLogCount(Long.valueOf(m.get("log_count").toString()));
        Object dropCount = m.get("drop_count");
        if (dropCount != null) {
            lo.setDropCount(Long.valueOf(dropCount.toString()));
        }
        if ((updateCount = m.get("update_count")) != null) {
            lo.setUpdateCount(Long.valueOf(updateCount.toString()));
        }
        lo.setConfigs((Map)m.get("configs"));
        lo.setStates((Map)m.get("states"));
        return lo;
    }

    private Date parseDate(String s) {
        if (s == null) {
            return null;
        }
        try {
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
            return f.parse(s);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void createLogger(LoggerInfo logger) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("factory", logger.getFactoryName());
        params.put("namespace", logger.getNamespace());
        params.put("name", logger.getName());
        params.put("description", logger.getDescription());
        params.put("options", logger.getConfigs());
        this.rpc("org.araqne.log.api.msgbus.LoggerPlugin.createLogger", params);
    }

    public void removeLogger(String fullName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("logger", fullName);
        this.rpc("org.araqne.log.api.msgbus.LoggerPlugin.removeLogger", params);
    }

    public void startLogger(String fullName, int interval) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("logger", fullName);
        params.put("interval", interval);
        this.rpc("org.araqne.log.api.msgbus.LoggerPlugin.startLogger", params);
    }

    public void stopLogger(String fullName, int waitTime) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("logger", fullName);
        params.put("wait_time", waitTime);
        this.rpc("org.araqne.log.api.msgbus.LoggerPlugin.stopLogger", params);
    }

    public List<JdbcProfileInfo> listJdbcProfiles() throws IOException {
        ArrayList<JdbcProfileInfo> l = new ArrayList<JdbcProfileInfo>();
        Message resp = this.rpc("org.logpresso.jdbc.JdbcProfilePlugin.getProfiles");
        List profiles = (List)resp.get("profiles");
        for (Object o : profiles) {
            Map m = (Map)o;
            JdbcProfileInfo info = new JdbcProfileInfo();
            info.setName((String)m.get("name"));
            info.setConnectionString((String)m.get("connection_string"));
            info.setReadOnly((Boolean)m.get("readonly"));
            info.setUser((String)m.get("user"));
            l.add(info);
        }
        return l;
    }

    public void createJdbcProfile(JdbcProfileInfo profile) throws IOException {
        this.checkNotNull("profile", profile);
        this.checkNotNull("profile.name", profile.getName());
        this.checkNotNull("profile.connectionString", profile.getConnectionString());
        this.checkNotNull("profile.user", profile.getUser());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", profile.getName());
        params.put("connection_string", profile.getConnectionString());
        params.put("readonly", profile.isReadOnly());
        params.put("user", profile.getUser());
        params.put("password", profile.getPassword());
        this.rpc("org.logpresso.jdbc.JdbcProfilePlugin.createProfile", params);
    }

    public void removeJdbcProfile(String name) throws IOException {
        this.checkNotNull("name", name);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        this.rpc("org.logpresso.jdbc.JdbcProfilePlugin.removeProfile", params);
    }

    public LogCursor query(String queryString) throws IOException {
        int id = this.createQuery(queryString);
        this.startQuery(id);
        LogQuery q = (LogQuery)this.queries.get(id);
        q.waitUntil(null);
        if (q.getStatus().equals("Cancelled")) {
            String errorMsg = "";
            if (q.getErrorCode() != null) {
                errorMsg = String.format(", error LOGPRESSO-%05d [%s]", q.getErrorCode(), q.getErrorDetail());
            }
            throw new IllegalStateException("query cancelled, id [" + q.getId() + "] query string [" + queryString + "]" + errorMsg);
        }
        long total = q.getLoadedCount();
        return new LogCursorImpl(id, 0L, total, true, this.fetchSize);
    }

    public List<StreamQueryStatus> listStreamQueries() throws IOException {
        Message resp = this.rpc("com.logpresso.query.msgbus.StreamQueryPlugin.getStreamQueries");
        List l = (List)resp.get("stream_queries");
        ArrayList<StreamQueryStatus> statuses = new ArrayList<StreamQueryStatus>();
        for (Object o : l) {
            StreamQueryStatus status = this.parseStreamQueryStatus(o);
            statuses.add(status);
        }
        return statuses;
    }

    public StreamQueryStatus getStreamQuery(String name) throws IOException {
        this.checkNotNull("name", name);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        Message resp = this.rpc("com.logpresso.query.msgbus.StreamQueryPlugin.getStreamQuery", params);
        Map o = (Map)resp.get("stream_query");
        if (o == null) {
            return null;
        }
        return this.parseStreamQueryStatus(o);
    }

    private StreamQueryStatus parseStreamQueryStatus(Object o) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
        StreamQueryStatus status = new StreamQueryStatus();
        Map m = (Map)o;
        Map c = (Map)m.get("config");
        StreamQueryInfo query = new StreamQueryInfo();
        query.setName((String)c.get("name"));
        query.setDescription((String)c.get("description"));
        query.setInterval((Integer)c.get("interval"));
        query.setQueryString((String)c.get("query"));
        query.setOwner((String)c.get("owner"));
        String sourceType = (String)c.get("source_type");
        query.setSourceType(sourceType);
        if (sourceType.equals("table")) {
            query.setSources((List)c.get("table"));
        } else if (sourceType.equals("logger")) {
            query.setSources((List)c.get("logger"));
        } else if (sourceType.equals("stream")) {
            query.setSources((List)c.get("stream"));
        }
        query.setEnabled((Boolean)c.get("is_enabled"));
        query.setCreated(df.parse((String)c.get("created"), new ParsePosition(0)));
        query.setModified(df.parse((String)c.get("modified"), new ParsePosition(0)));
        status.setStreamQuery(query);
        status.setInputCount(Long.parseLong(m.get("input_count").toString()));
        status.setLastRefresh(df.parse((String)m.get("last_refresh"), new ParsePosition(0)));
        status.setRunning((Boolean)m.get("is_running"));
        return status;
    }

    public void createStreamQuery(StreamQueryInfo query) throws IOException {
        Map<String, Object> params = this.buildStreamQueryParams(query);
        this.rpc("com.logpresso.query.msgbus.StreamQueryPlugin.createStreamQuery", params);
    }

    public void updateStreamQuery(StreamQueryInfo query) throws IOException {
        Map<String, Object> params = this.buildStreamQueryParams(query);
        this.rpc("com.logpresso.query.msgbus.StreamQueryPlugin.updateStreamQuery", params);
    }

    private Map<String, Object> buildStreamQueryParams(StreamQueryInfo query) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", query.getName());
        params.put("description", query.getDescription());
        params.put("interval", query.getInterval());
        params.put("source_type", query.getSourceType());
        params.put("sources", query.getSources());
        params.put("query", query.getQueryString());
        params.put("is_enabled", query.isEnabled());
        return params;
    }

    public void removeStreamQuery(String name) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        this.rpc("com.logpresso.query.msgbus.StreamQueryPlugin.removeStreamQuery", params);
    }

    public List<ScheduledQueryInfo> listScheduledQueries() throws IOException {
        Message resp = this.rpc("com.logpresso.core.msgbus.ScheduledQueryPlugin.getScheduledQueries");
        List l = (List)resp.get("scheduled_queries");
        ArrayList<ScheduledQueryInfo> queries = new ArrayList<ScheduledQueryInfo>();
        for (Object o : l) {
            queries.add(this.parseScheduledQuery(o));
        }
        return queries;
    }

    public ScheduledQueryInfo getScheduledQuery(String guid) throws IOException {
        this.checkNotNull("guid", guid);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("guid", guid);
        Message resp = this.rpc("com.logpresso.core.msgbus.ScheduledQueryPlugin.getScheduledQuery", params);
        return this.parseScheduledQuery(resp.get("scheduled_query"));
    }

    private ScheduledQueryInfo parseScheduledQuery(Object o) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
        Map m = (Map)o;
        ScheduledQueryInfo query = new ScheduledQueryInfo();
        query.setGuid((String)m.get("guid"));
        query.setTitle((String)m.get("title"));
        query.setCronSchedule((String)m.get("cron_schedule"));
        query.setOwner((String)m.get("owner"));
        query.setQueryString((String)m.get("query"));
        query.setSaveResult((Boolean)m.get("use_save_result"));
        query.setUseAlert((Boolean)m.get("use_alert"));
        query.setAlertQuery((String)m.get("alert_query"));
        query.setSuppressInterval((Integer)m.get("suppress_interval"));
        query.setMailProfile((String)m.get("mail_profile"));
        query.setMailFrom((String)m.get("mail_from"));
        query.setMailTo((String)m.get("mail_to"));
        query.setMailSubject((String)m.get("mail_subject"));
        query.setEnabled((Boolean)m.get("is_enabled"));
        query.setCreated(df.parse((String)m.get("created_at"), new ParsePosition(0)));
        return query;
    }

    public void createScheduledQuery(ScheduledQueryInfo query) throws IOException {
        Map<String, Object> params = this.buildScheduledQueryParams(query);
        this.rpc("com.logpresso.core.msgbus.ScheduledQueryPlugin.createScheduledQuery", params);
    }

    public void updateScheduledQuery(ScheduledQueryInfo query) throws IOException {
        Map<String, Object> params = this.buildScheduledQueryParams(query);
        this.rpc("com.logpresso.core.msgbus.ScheduledQueryPlugin.updateScheduledQuery", params);
    }

    private Map<String, Object> buildScheduledQueryParams(ScheduledQueryInfo query) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("guid", query.getGuid());
        params.put("title", query.getTitle());
        params.put("cron_schedule", query.getCronSchedule());
        params.put("query", query.getQueryString());
        params.put("save_result", query.isSaveResult());
        params.put("use_alert", query.isUseAlert());
        params.put("alert_query", query.getAlertQuery());
        params.put("suppress_interval", query.getSuppressInterval());
        params.put("mail_profile", query.getMailProfile());
        params.put("mail_from", query.getMailFrom());
        params.put("mail_to", query.getMailTo());
        params.put("mail_subject", query.getMailSubject());
        params.put("is_enabled", query.isEnabled());
        return params;
    }

    public void removeScheduledQuery(String guid) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("guid", guid);
        this.rpc("com.logpresso.core.msgbus.ScheduledQueryPlugin.removeScheduledQuery", params);
    }

    public int createQuery(String queryString) throws IOException {
        return this.createQuery(queryString, null);
    }

    public int createQuery(String queryString, StreamingResultSet rs) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("query", queryString);
        params.put("source", "java-client");
        Message resp = this.rpc("org.araqne.logdb.msgbus.LogQueryPlugin.createQuery", params);
        int id = resp.getInt("id");
        this.session.registerTrap("logdb-query-" + id);
        this.session.registerTrap("logdb-query-timeline-" + id);
        if (rs != null) {
            this.streamCallbacks.put(id, rs);
            this.session.registerTrap("logdb-query-result-" + id);
        }
        this.queries.putIfAbsent(id, new LogQuery(this, id, queryString));
        return id;
    }

    public void startQuery(int id) throws IOException {
        this.verifyQueryId(id);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("streaming", this.streamCallbacks.containsKey(id));
        this.rpc("org.araqne.logdb.msgbus.LogQueryPlugin.startQuery", params);
    }

    public void stopQuery(int id) throws IOException {
        this.verifyQueryId(id);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        this.rpc("org.araqne.logdb.msgbus.LogQueryPlugin.stopQuery", params);
    }

    public void removeQuery(int id) throws IOException {
        this.verifyQueryId(id);
        StreamingResultSet rs = (StreamingResultSet)this.streamCallbacks.remove(id);
        if (rs != null) {
            this.session.unregisterTrap("logdb-query-result-" + id);
        }
        this.session.unregisterTrap("logdb-query-" + id);
        this.session.unregisterTrap("logdb-query-timeline-" + id);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        this.rpc("org.araqne.logdb.msgbus.LogQueryPlugin.removeQuery", params);
        this.queries.remove(id);
    }

    public void addFailureListener(FailureListener listener) {
        this.failureListeners.add(listener);
    }

    public void removeFailureListener(FailureListener listener) {
        this.failureListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Integer> insert(String tableName, List<Row> rows) {
        for (Row row : rows) {
            if (row.get("_time") != null && row.get("_time") instanceof Date) continue;
            row.put("_time", new Date());
        }
        QueuedRows ret = null;
        if (this.flusher.get() == null && this.flusher.compareAndSet(null, new Flusher())) {
            this.flusher.get().start();
        }
        Map<String, List<QueuedRows>> map = this.flushBuffers;
        synchronized (map) {
            if (!this.flushBuffers.containsKey(tableName)) {
                this.flushBuffers.put(tableName, new ArrayList());
            }
            QueuedRows qr = new QueuedRows(rows, this.flusher.get());
            this.flushBuffers.get(tableName).add(qr);
            ret = qr;
            this.counter += rows.size();
        }
        if (this.counter >= this.insertBatchSize) {
            this.flusher.get().signal();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Integer> insert(String tableName, Row row) {
        if (row.get("_time") == null || !(row.get("_time") instanceof Date)) {
            row.put("_time", new Date());
        }
        QueuedRows ret = null;
        if (this.flusher.get() == null && this.flusher.compareAndSet(null, new Flusher())) {
            this.flusher.get().start();
        }
        Map<String, List<QueuedRows>> map = this.flushBuffers;
        synchronized (map) {
            if (!this.flushBuffers.containsKey(tableName)) {
                this.flushBuffers.put(tableName, new ArrayList());
            }
            QueuedRows qr = new QueuedRows(Arrays.asList(row), this.flusher.get());
            this.flushBuffers.get(tableName).add(qr);
            ret = qr;
            ++this.counter;
        }
        if (this.counter >= this.insertBatchSize) {
            this.flusher.get().signal();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.counter == 0) {
            return;
        }
        HashMap<String, List<QueuedRows>> binsMap = null;
        Map<String, List<QueuedRows>> map = this.flushBuffers;
        synchronized (map) {
            binsMap = new HashMap<String, List<QueuedRows>>(this.flushBuffers);
            this.flushBuffers.clear();
            this.counter = 0;
        }
        for (Map.Entry entry : binsMap.entrySet()) {
            String tableName = (String)entry.getKey();
            List items = (List)entry.getValue();
            try {
                ArrayList<Object> l = new ArrayList<Object>(items.size());
                for (QueuedRows rows : items) {
                    for (Row row : rows.getRows()) {
                        l.add(row.map());
                    }
                }
                List<Map<String, Object>> bins = this.streamingEncoder.encode(l, false);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("table", entry.getKey());
                params.put("bins", bins);
                this.rpc("org.araqne.logdb.msgbus.LogQueryPlugin.insertBatch", params);
                for (QueuedRows rows : items) {
                    rows.setDone();
                }
            }
            catch (Throwable t) {
                this.logger.debug("araqne logdb client: cannot insert data", t);
                for (QueuedRows rows : items) {
                    rows.setDone(t);
                    for (FailureListener c : this.failureListeners) {
                        try {
                            c.onInsertFailure(tableName, rows.getRows(), t);
                        }
                        catch (Throwable t2) {
                            this.logger.debug("araqne logdb client: insert failure callback should not throw any exception", t2);
                        }
                    }
                }
            }
        }
    }

    public void waitUntil(int id, Long count) {
        this.verifyQueryId(id);
        ((LogQuery)this.queries.get(id)).waitUntil(count);
    }

    public Map<String, Object> getResult(int id, long offset, int limit) throws IOException {
        this.verifyQueryId(id);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("offset", offset);
        params.put("limit", limit);
        params.put("binary_encode", true);
        Message resp = this.rpc("org.araqne.logdb.msgbus.LogQueryPlugin.getResult", params);
        if (resp.getParameters().size() == 0) {
            throw new MessageException("query-not-found", "", resp.getParameters());
        }
        if (!resp.getParameters().containsKey("uncompressed_size")) {
            return resp.getParameters();
        }
        int uncompressedSize = (Integer)resp.getParameters().get("uncompressed_size");
        String binary = (String)resp.getParameters().get("binary");
        return this.decodeBinary(binary, uncompressedSize);
    }

    private Map<String, Object> decodeBinary(String binary, int uncompressedSize) {
        byte[] b = Base64.decode(binary);
        byte[] uncompressed = new byte[uncompressedSize];
        this.uncompress(uncompressed, b);
        Map<String, Object> m = EncodingRule.decodeMap(ByteBuffer.wrap(uncompressed));
        Object[] resultArray = (Object[])m.get("result");
        m.put("result", Arrays.asList(resultArray));
        return m;
    }

    private void uncompress(byte[] output, byte[] b) {
        Inflater inflater = new Inflater();
        inflater.setInput(b, 0, b.length);
        try {
            inflater.inflate(output);
            inflater.reset();
        }
        catch (DataFormatException e) {
            throw new IllegalStateException(e);
        }
        finally {
            inflater.end();
        }
    }

    private void verifyQueryId(int id) {
        if (!this.queries.containsKey(id)) {
            throw new MessageException("query-not-found", "query [" + id + "] does not exist", null);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.counter > 0) {
            this.flush();
        }
        if (this.session != null) {
            this.session.close();
        }
        if (this.streamingDecoder != null) {
            this.streamingDecoder.close();
            this.streamingDecoder = null;
        }
        if (this.flusher.get() != null) {
            this.flusher.get().shutdown();
        }
        if (this.streamingEncoder != null) {
            this.streamingEncoder.close();
            this.streamingEncoder = null;
        }
    }

    @Override
    public void onTrap(Message msg) {
        String method = msg.getMethod();
        long stamp = 0L;
        if (msg.containsKey("stamp")) {
            stamp = Long.parseLong(msg.get("stamp").toString());
        }
        if (method.startsWith("logdb-query-timeline-")) {
            int id = msg.getInt("id");
            LogQuery q = (LogQuery)this.queries.get(id);
            q.updateCount(msg.getLong("count"), stamp);
            if (msg.getString("type").equals("eof")) {
                q.updateStatus("Ended", stamp);
            }
        } else if (method.startsWith("logdb-query-result-")) {
            this.handleStreamingResult(msg);
        } else if (method.startsWith("logdb-query-")) {
            int id = msg.getInt("id");
            LogQuery q = (LogQuery)this.queries.get(id);
            if (msg.getString("type").equals("eof")) {
                q.updateCount(msg.getLong("total_count"), stamp);
                if (msg.get("error_code") != null) {
                    q.setErrorCode((Integer)msg.get("error_code"));
                    q.setErrorDetail((String)msg.get("error_detail"));
                    q.updateStatus("Cancelled", stamp);
                } else {
                    q.updateStatus("Ended", stamp);
                }
            } else if (msg.getString("type").equals("page_loaded")) {
                q.updateCount(msg.getLong("count"), stamp);
                q.updateStatus("Running", stamp);
            } else if (msg.getString("type").equals("status_change")) {
                q.updateCount(msg.getLong("count"), stamp);
                q.updateStatus(msg.getString("status"), stamp);
            }
        }
    }

    private void handleStreamingResult(Message msg) {
        block7: {
            List chunks = (List)msg.get("bins");
            boolean last = msg.getBoolean("last");
            boolean lastCalled = false;
            int queryId = Integer.valueOf(msg.getMethod().substring("logdb-query-result-".length()));
            StreamingResultSet rs = null;
            LogQuery query = null;
            try {
                query = (LogQuery)this.queries.get(queryId);
                rs = (StreamingResultSet)this.streamCallbacks.get(queryId);
                ArrayList<Row> rows = null;
                List l = null;
                l = chunks != null ? this.streamingDecoder.decode(chunks) : (List)msg.get("rows");
                rows = new ArrayList<Row>(l.size());
                for (Object o : l) {
                    rows.add(new Row((Map)o));
                }
                if (query != null && rs != null) {
                    rs.onRows(query, rows, last);
                    if (last) {
                        lastCalled = true;
                    }
                }
            }
            catch (ExecutionException e) {
                this.logger.error("araqne logdb client: cannot decode streaming result", e);
                if (query != null && rs != null && last && !lastCalled) {
                    rs.onRows(query, new ArrayList<Row>(), true);
                }
            }
            catch (Throwable t) {
                if (query == null || rs == null || !last || lastCalled) break block7;
                rs.onRows(query, new ArrayList<Row>(), true);
            }
        }
    }

    @Override
    public void onClose(Throwable t) {
        for (LogQuery q : this.queries.values()) {
            q.updateStatus("Cancelled", Long.MAX_VALUE);
        }
    }

    private void checkNotNull(String name, Object o) {
        if (o == null) {
            throw new IllegalArgumentException(name + " parameter should be not null");
        }
    }

    private Message rpc(String method) throws IOException {
        if (this.session == null) {
            throw new IOException("not connected yet, use connect()");
        }
        return this.session.rpc(method);
    }

    private Message rpc(String method, Map<String, Object> params) throws IOException {
        if (this.session == null) {
            throw new IOException("not connected yet, use connect()");
        }
        return this.session.rpc(method, params);
    }

    public Map<String, Object> getNodeByGuid(String instanceGuid) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("instance_guid", instanceGuid);
        Message resp = this.rpc("com.logpresso.query.msgbus.FederationPlugin.getNodeByGuid", params);
        Map nodeInfo = (Map)resp.get("node");
        return nodeInfo;
    }

    public String getInstanceGuid() throws IOException {
        Message resp = this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.getInstanceGuid");
        String l = (String)resp.get("instance_guid");
        return l;
    }

    public PeerStatus getPeerStatus(String instanceGuid) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("instance_guid", instanceGuid);
        Message resp = this.rpc("com.logpresso.query.msgbus.FederationPlugin.getPeerStatus", params);
        return new PeerStatus(resp.get("peer_status"));
    }

    public class Flusher
    implements Runnable {
        Thread th;
        volatile boolean running = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Flusher flusher = this;
            synchronized (flusher) {
                if (this.th == null) {
                    this.th = new Thread((Runnable)this, "Insert flush thread");
                    this.th.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                try {
                    long started = System.nanoTime();
                    LogDbClient.this.flush();
                    long nextWaitMillis = (long)LogDbClient.this.indexFlushInterval - (System.nanoTime() - started) / 1000000L;
                    if (nextWaitMillis <= 0L) continue;
                    Flusher flusher = this;
                    synchronized (flusher) {
                        this.wait(nextWaitMillis);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        void shutdown() {
            this.running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void signal() {
            Flusher flusher = this;
            synchronized (flusher) {
                this.notifyAll();
            }
        }
    }

    private static class QueuedRows
    implements Future<Integer> {
        private List<Row> rows;
        CountDownLatch l = new CountDownLatch(1);
        private volatile Throwable t;
        private Flusher flusher;

        public QueuedRows(List<Row> rows, Flusher flusher) {
            this.rows = rows;
            this.flusher = flusher;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        public void setDone() {
            this.l.countDown();
        }

        public void setDone(Throwable t) {
            this.t = t;
            this.l.countDown();
        }

        @Override
        public Integer get() throws InterruptedException, ExecutionException {
            this.flusher.signal();
            this.l.await();
            if (this.t != null) {
                throw new ExecutionException(this.t);
            }
            return this.rows.size();
        }

        @Override
        public Integer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.flusher.signal();
            if (this.l.await(timeout, unit)) {
                if (this.t != null) {
                    throw new ExecutionException(this.t);
                }
                return this.rows.size();
            }
            throw new TimeoutException();
        }

        public List<Row> getRows() {
            return this.rows;
        }
    }

    private class LogCursorImpl
    implements LogCursor {
        private int id;
        private long offset;
        private long limit;
        private boolean removeOnClose;
        private long p;
        private Map<String, Object> cached;
        private Long currentCacheOffset;
        private Long nextCacheOffset;
        private int fetchUnit;
        private Map<String, Object> prefetch;

        public LogCursorImpl(int id, long offset, long limit, boolean removeOnClose, int fetchUnit) {
            this.id = id;
            this.offset = offset;
            this.limit = limit;
            this.removeOnClose = removeOnClose;
            this.p = offset;
            this.nextCacheOffset = offset;
            this.fetchUnit = fetchUnit;
        }

        @Override
        public boolean hasNext() {
            if (this.prefetch != null) {
                return true;
            }
            if (this.p < this.offset || this.p >= this.offset + this.limit) {
                return false;
            }
            try {
                List l;
                int relative;
                if (this.cached == null || this.p >= this.currentCacheOffset + (long)this.fetchUnit) {
                    this.cached = LogDbClient.this.getResult(this.id, this.nextCacheOffset, this.fetchUnit);
                    this.currentCacheOffset = this.nextCacheOffset;
                    this.nextCacheOffset = this.nextCacheOffset + (long)this.fetchUnit;
                }
                if ((relative = (int)(this.p - this.currentCacheOffset)) >= (l = (List)this.cached.get("result")).size()) {
                    return false;
                }
                this.prefetch = (Map)l.get(relative);
                ++this.p;
                return true;
            }
            catch (IOException e) {
                LogDbClient.this.logger.error("araqne logdb client: cannot fetch log query result", e);
                return false;
            }
        }

        @Override
        public Map<String, Object> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("end of log cursor");
            }
            Map<String, Object> m = this.prefetch;
            this.prefetch = null;
            return m;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            if (this.removeOnClose) {
                LogDbClient.this.removeQuery(this.id);
            }
        }
    }
}

