/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.codec;

import java.io.UnsupportedEncodingException;
import org.araqne.codec.EncodingRule;

public class EncodedStringCache {
    private byte[] value;
    private int rawNumberLength;

    public static EncodedStringCache getEncodedString(String value) {
        return new EncodedStringCache(value);
    }

    private EncodedStringCache(String value) {
        try {
            this.value = value.getBytes("utf-8");
            this.rawNumberLength = EncodingRule.lengthOfRawNumber(Integer.TYPE, this.value.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public int length() {
        return 1 + this.rawNumberLength + this.value.length;
    }

    public byte[] value() {
        return this.value;
    }
}

