/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ScriptOptionParser {
    private ArrayList<String> args;

    public ScriptOptionParser(String[] args) {
        this.args = new ArrayList<String>(Arrays.asList(args));
    }

    public ScriptOption getOption(String shortOpt, boolean hasArg) {
        return this.getOption(shortOpt, null, hasArg);
    }

    public ScriptOption getOption(String shortOpt, String longOpt, boolean hasArg) {
        String arg;
        ScriptOption option = null;
        Iterator<String> iterator = this.args.iterator();
        boolean needsArg = false;
        String pfshort = "-" + shortOpt;
        String pflong = "--" + longOpt;
        while (iterator.hasNext() && !(arg = iterator.next()).equals("--")) {
            if (arg.startsWith("-") && (arg.startsWith(pfshort) || arg.startsWith(pflong))) {
                if (option != null && needsArg) {
                    throw new IllegalArgumentException("no argument supplied for option \"" + option.name + "\"");
                }
                if (option == null) {
                    option = new ScriptOption(shortOpt, longOpt);
                }
                boolean isShort = arg.startsWith(pfshort);
                iterator.remove();
                if (!hasArg) continue;
                if (isShort && arg.length() > 2) {
                    option.addArg(arg.substring(2));
                    continue;
                }
                if (!isShort && arg.startsWith(pflong + "=")) {
                    option.addArg(arg.substring(pflong.length() + 1));
                    continue;
                }
                needsArg = true;
                continue;
            }
            if (!needsArg) continue;
            option.addArg(arg);
            iterator.remove();
            needsArg = false;
        }
        if (option != null && needsArg) {
            throw new IllegalArgumentException("no argument supplied for option \"" + option.name + "\"");
        }
        return option;
    }

    public List<String> getArguments() {
        ArrayList<String> result = new ArrayList<String>(this.args.size());
        for (String arg : this.args) {
            if (arg.equals("--")) continue;
            result.add(arg);
        }
        return result;
    }

    public static class ScriptOption {
        public String name;
        public String longName;
        public List<String> values;

        public ScriptOption(String shortName, String longName) {
            this.name = shortName;
            this.longName = longName;
        }

        public void addArg(String arg) {
            if (this.values == null) {
                this.values = new ArrayList<String>();
            }
            this.values.add(arg);
        }

        public String getName() {
            return this.name != null ? this.name : this.longName;
        }
    }
}

