/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.araqne.api.ScriptAutoCompletion;
import org.araqne.api.ScriptAutoCompletionHelper;
import org.araqne.api.ScriptSession;

public class PathAutoCompleter
implements ScriptAutoCompletionHelper {
    private FilterOption filterOption;

    public PathAutoCompleter() {
        this.filterOption = FilterOption.All;
    }

    public PathAutoCompleter(FilterOption filterOption) {
        this.filterOption = filterOption;
    }

    @Override
    public List<ScriptAutoCompletion> matches(ScriptSession session, String prefix) {
        File dir = (File)session.getProperty("dir");
        int p = prefix.lastIndexOf(47);
        String parent = null;
        if (p > 0) {
            parent = prefix.substring(0, p);
        } else if (p == 0) {
            parent = "/";
        }
        ArrayList<ScriptAutoCompletion> paths = new ArrayList<ScriptAutoCompletion>();
        String filePrefix = p >= 0 ? prefix.substring(p + 1) : prefix;
        File parentFile = this.canonicalize(dir, parent);
        if (parentFile == null) {
            return paths;
        }
        boolean absolute = parent != null && (parent.startsWith("/") || this.isWindowsDriveRoot(parentFile.getAbsolutePath()));
        File[] files = null;
        files = parent != null && parent.equals("/") && File.separatorChar == '\\' ? File.listRoots() : parentFile.listFiles();
        if (files == null) {
            return paths;
        }
        for (File f : files) {
            String name = f.getName();
            if (!name.startsWith(filePrefix) || this.filterOption == FilterOption.DirectoryOnly && !f.isDirectory() || this.filterOption == FilterOption.FileOnly && !f.isFile()) continue;
            if (absolute) {
                String path = f.getAbsolutePath();
                try {
                    path = f.getCanonicalPath();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                path = path.replaceAll("\\\\", "/");
                if (f.isDirectory() && !path.endsWith("/")) {
                    path = path + "/";
                }
                if (!path.toLowerCase().startsWith(prefix.toLowerCase())) continue;
                paths.add(new ScriptAutoCompletion(path, name));
                continue;
            }
            if (f.isDirectory()) {
                name = name + "/";
            }
            if (p > 0) {
                String completion = parent + "/" + name;
                if (!completion.toLowerCase().startsWith(prefix.toLowerCase())) continue;
                paths.add(new ScriptAutoCompletion(completion, name));
                continue;
            }
            if (!name.toLowerCase().startsWith(prefix.toLowerCase())) continue;
            paths.add(new ScriptAutoCompletion(name));
        }
        return paths;
    }

    private File canonicalize(File dir, String path) {
        try {
            if (path == null || path.isEmpty()) {
                return dir.getCanonicalFile();
            }
            if (path.startsWith("/") || this.isWindowsDriveRoot(path)) {
                File f = new File(path.endsWith("/") ? path : path + "/");
                return f.getCanonicalFile();
            }
            return new File(dir, path).getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean isWindowsDriveRoot(String path) {
        try {
            File f = new File(path);
            for (File root : File.listRoots()) {
                String s2;
                String s1 = root.getCanonicalPath();
                if (!s1.equals(s2 = f.getCanonicalPath())) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    static enum FilterOption {
        All,
        DirectoryOnly,
        FileOnly;

    }
}

