/*
 * Decompiled with CFR 0.152.
 */
package com.bethecoder.ascii_table;

import com.bethecoder.ascii_table.ASCIITable;
import com.bethecoder.ascii_table.ASCIITableHeader;
import com.bethecoder.ascii_table.impl.CollectionASCIITableAware;
import com.bethecoder.ascii_table.impl.JDBCASCIITableAware;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public class Test {
    public static void main(String[] args) throws Exception {
        Test.basicTests();
        Test.collectionTests();
    }

    private static void basicTests() {
        String[] header = new String[]{"User Name", "Salary", "Designation", "Address", "Lucky#"};
        String[][] data = new String[][]{{"Ram", "2000", "Manager", "#99, Silk board", "1111"}, {"Sri", "12000", "Developer", "BTM Layout", "22222"}, {"Prasad", "42000", "Lead", "#66, Viaya Bank Layout", "333333"}, {"Anu", "132000", "QA", "#22, Vizag", "4444444"}, {"Sai", "62000", "Developer", "#3-3, Kakinada"}, {"Venkat", "2000", "Manager"}, {"Raj", "62000"}, {"BTC"}};
        ASCIITableHeader[] headerObjs = new ASCIITableHeader[]{new ASCIITableHeader("User Name", -1), new ASCIITableHeader("Salary"), new ASCIITableHeader("Designation", 0), new ASCIITableHeader("Address", -1), new ASCIITableHeader("Lucky#", 1)};
        ASCIITable.getInstance().printTable(headerObjs, data);
        ASCIITable.getInstance().printTable(header, data);
        System.out.println(ASCIITable.getInstance().getTable(headerObjs, data));
    }

    private static void h2JDBCTests() throws ClassNotFoundException, SQLException {
        Class.forName("org.h2.Driver");
        Connection conn = DriverManager.getConnection("jdbc:h2:tcp://localhost/~/test", "sa", "");
        JDBCASCIITableAware asciiTableAware = new JDBCASCIITableAware(conn, "select STATUS, COUNT from BUG_STAT");
        ASCIITable.getInstance().printTable(asciiTableAware);
        asciiTableAware = new JDBCASCIITableAware(conn, "select * from USER");
        ASCIITable.getInstance().printTable(asciiTableAware);
    }

    private static void oracleJDBCTests() throws ClassNotFoundException, SQLException {
        Class.forName("oracle.jdbc.driver.OracleDriver");
        Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521:ORADBVENKAT", "digital_transformation", "digital_transformation");
        JDBCASCIITableAware asciiTableAware = new JDBCASCIITableAware(conn, "select * from CONTACTINFO");
        ASCIITable.getInstance().printTable(asciiTableAware);
    }

    private static void collectionTests() {
        Employee stud = new Employee("Sriram", 2, "Chess", false, 9.8765432121E8);
        Employee stud2 = new Employee("Sudhakar", 29, "Painting", true, 1.2345678912E8);
        List<Employee> students = Arrays.asList(stud, stud2);
        CollectionASCIITableAware<Employee> asciiTableAware = new CollectionASCIITableAware<Employee>(students, "name", "age", "married", "hobby", "salary");
        ASCIITable.getInstance().printTable(asciiTableAware);
        asciiTableAware = new CollectionASCIITableAware<Employee>(students, Arrays.asList("name", "age", "married", "hobby", "salary"), Arrays.asList("STUDENT_NAME", "HIS_AGE"));
        ASCIITable.getInstance().printTable(asciiTableAware);
    }

    public static class Employee {
        private String name;
        private int age;
        private String hobby;
        private boolean married;
        private double salary;

        public Employee(String name, int age, String hobby, boolean married, double salary) {
            this.name = name;
            this.age = age;
            this.hobby = hobby;
            this.married = married;
            this.salary = salary;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public String getHobby() {
            return this.hobby;
        }

        public void setHobby(String hobby) {
            this.hobby = hobby;
        }

        public boolean isMarried() {
            return this.married;
        }

        public void setMarried(boolean married) {
            this.married = married;
        }

        public double getSalary() {
            return this.salary;
        }

        public void setSalary(double salary) {
            this.salary = salary;
        }
    }
}

