import os, re

from subprocess import Popen, PIPE

THISDIR_RE=re.compile("What's new in \"(.*)\"")

def exec_darcs(darcscmd):
    cmd = ['darcs'] + darcscmd
    try:
        p = Popen(cmd, stdout=PIPE, stderr=PIPE, universal_newlines=True)
    except EnvironmentError:
        cmd = ['realdarcs.exe'] + darcscmd
        p = Popen(cmd, stdout=PIPE, stderr=PIPE, universal_newlines=True)
        
    output = p.communicate()[0]
    return (p.returncode, output)

def run_darcs_query_manifest():
    return exec_darcs(['query', 'manifest'])

def run_darcs_whatsnew_dot_s():
    return exec_darcs(['whatsnew', '.', '-s'])

def find_files_for_darcs(dirname):
    try:
        unused, whatsnewoutput = run_darcs_whatsnew_dot_s()
        queryretcode, queryoutput = run_darcs_query_manifest()
    except EnvironmentError:
        # Oh well -- just return None.
        return

    if queryretcode != 0:
        # Oh well -- just return None.
        return

    # We got output.
    mo = THISDIR_RE.search(whatsnewoutput)
    if mo:
        curdirname = mo.group(1)
        while curdirname.endswith('/'):
            curdirname = curdirname[:-1]
        curdirname += "/"
    else:
        curdirname = ""

    # Prepend this directory.
    dirname = curdirname + dirname

    # Normalize dirname from local form to the form that setuptools uses to the form that "darcs query manifest" outputs (unix form).
    dirname = dirname.replace('\\', '/')
    while dirname.endswith('/'):
        dirname = dirname[:-1]

    # Append a '/' to make sure we don't match "foobar" when dirname is "foo".
    if dirname:
        dirname += '/'

    for fn in queryoutput.split('\n'):
        if fn == ".":
            continue
        if fn.startswith('./'):
            fn = fn[2:]
        if fn.startswith(dirname):
            fn = fn[len(dirname):]
            yield fn
