# -*- coding: utf-8 -*-
"""
/***************************************************************************
 * 
 * Copyright (c) 2015 Baidu.com, Inc. All Rights Reserved
 * $Id$ 
 * 
 **************************************************************************/
 
 
 
/**
 * @file utils.py
 * @author daiwenkai(daiwenkai@baidu.com)
 * @date 2015/01/18 19:58:31
 * @version $Revision$ 
 * @brief useful functions
 *  
 **/
"""
import logging
import sys
import traceback
import json
import os

os.sys.path.append(os.path.dirname(os.path.abspath(__file__))+"/../")

import globals.globals as globals

def trans_cyc(arr):
    """
    将输入转换为adcore期待的输入
    input: arr,例：{"0": [22, 13, 5], "2": [0, 7, 21, 23]}
            key表示星期几（1-7, 周一到周日）
            value数组表示几点（0-23, 周一到周日）
    """
    # 8 * 25的数组
    # 第0行都是0, 
    # 最后一列都是0, 
    # 第1行到第7行分别表示星期一到星期日.
    # 0-23列代表小时, 值0表示该小时开启, 值1表示该小时暂停

    cyc = [
            [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
            [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
            [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
            [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
            [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
            [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
            [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
            [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
            ]
    arr_size = len(arr)
    
    for key in arr.keys():
        for item in arr[key]:
            cyc[int(key)][item] = 1
    
    return cyc


def print_exception(exception, file):
    """
    print exception: 将exception信息打印出来
    """
    error = {}
    error["exception"] = str(exception)
    error["file"] = file
    error["line"] = str(traceback.extract_stack()[-2][1])
    error["detail"] = str(sys.exc_info()[: 2])
    logging.warning(json.dumps(error))


def check_params_length(params, exp_length, method):
    """
    check params length:检查params的长度是否符合预期
    返回二元组：
    0: True=>符合预期，False=>不符合预期
    1: (res_info, res_err_detail, res_data)
        True时为空
        False时，
            res_info的status填STATUS_REQ_PARAMS_ERR
            res_err_detail填method的信息进去
            res_data填空
    """
    if len(params) == exp_length:
        return (True, ())
    else:
        stat = False
        err_str = "params of " + method + " illegal! "
        err_str += "[exp_len: " + str(exp_length) + "] "
        err_str += "[actual_len: " + str(len(params)) + "] "
        logging.warning(err_str)
        res_info = {}
        res_info["status"] = globals.STATUS_REQ_PARAMS_ERR
        res_err_detail = {"error": err_str}
        res_data = {}
        res_info["succ_count"] = len(res_data)
        res_info["fail_count"] = len(res_err_detail.keys())
        return (stat, (res_info, res_err_detail, res_data))


def set_default_res(attr, value, exp_value):
    """
    返回三元组：
    (res_info, res_err_detail, res_data)
        res_info的status填STATUS_REQ_PARAMS_ERR
        res_err_detail填出错信息
        res_data填空
    """
    err_str = "value of " + attr + " illegal! "
    err_str += "[actual_val: " + str(value) + "] "
    err_str += "[exp_val: " + str(exp_value) + "] "
    logging.warning(err_str)
    res_info = {}
    res_info["status"] = globals.STATUS_REQ_PARAMS_ERR
    res_err_detail = {"error": err_str}
    res_data = {}
    res_info["succ_count"] = len(res_data)
    res_info["fail_count"] = len(res_err_detail.keys())
    return (res_info, res_err_detail, res_data)


def check_mod_keys_valid(params, method, invalid_key):
    """
    对于mod的请求（modPlan, modWinfo, modIdea, modUnit等），
    判断items中是否有非预期的invalid_key,返回结果与check_params_length类似
    返回二元组：
    0: True=>符合预期，False=>不符合预期
    1: (res_info, res_err_detail, res_data)
        True时为空
        False时，
            res_info的status填STATUS_REQ_PARAMS_INVALID_KEY_ERR
            res_err_detail填method的信息进去
            res_data填空
    """
    reqs = params[1]
    stat = True

    for elem in reqs:
        if "items" not in elem.keys():
            stat = False 
            break
        items = elem["items"]
        if invalid_key in items.keys():
            stat = False 
            break

    if False == stat:
        err_str = "params of " + method + " illegal! "
        err_str += "invalid key [" + invalid_key + "] included!"
        logging.warning(err_str)
        res_info = {}
        res_info["status"] = globals.STATUS_REQ_PARAMS_INVALID_KEY_ERR
        res_err_detail = {"error": err_str}
        res_data = {}
        res_info["succ_count"] = len(res_data)
        res_info["fail_count"] = len(res_err_detail.keys())
        return (stat, (res_info, res_err_detail, res_data))

    return (True, ())

"""
/* vim: set ts=4 sw=4 sts=4 tw=100 */
"""
