# -*- coding: utf-8 -*-
"""
/***************************************************************************
 * 
 * Copyright (c) 2015 Baidu.com, Inc. All Rights Reserved
 * $Id$ 
 * 
 **************************************************************************/
 
 
 
/**
 * @file configmgr.py
 * @author daiwenkai(daiwenkai@baidu.com)
 * @date 2015/01/06 23:22:20
 * @version $Revision$ 
 * @brief 
 *  
 **/
"""

import os
import logging
os.sys.path.append(os.path.dirname(os.path.abspath(__file__))+"/../../")

import tools.configures.configure as configure
import tools.log as log
import tools.utils as utils
import globals.globals as globals

abs_path = os.path.dirname(os.path.abspath(__file__)) + "/../../../"

class ConfigMgr(object):
    """
    ConfigMgr
    """

    def __init__(self, file):
        """
        init ConfigMgr
        """
        try: 
            self.global_conf = configure.Configure(file)
        
            # 初始化conn_type
            self.conn_type = self.global_conf.get("type", "conn_type")

            # 初始化log_file
            path = self.global_conf.get("log", "path") 
            file = self.global_conf.get("log", "file") 
            self.log_file = abs_path + path + file

            # 初始化ConnectionGroups
            self.urls = []
            self.ports = []
            self.timeouts = []
            self.conn_group_num = int(
                    self.global_conf.get("ConnectionGroupNum", "count"))
            for i in xrange(0, self.conn_group_num):
                group_name = "ConnectionGroup" + str(i)
                url = self.global_conf.get(group_name, "url") 
                port = self.global_conf.get(group_name, "port") 
                timeout = self.global_conf.get(group_name, "timeout")
                self.urls.append(url)
                self.ports.append(int(port))
                self.timeouts.append(int(timeout))

            # 初始化各model的conf
            path = self.global_conf.get("conf", "path") 
            file = self.global_conf.get("conf", "plan") 
            plan_file = abs_path + path + file
            self.plan_conf = configure.Configure(plan_file)

            file = self.global_conf.get("conf", "unit") 
            unit_file = abs_path + path + file
            self.unit_conf = configure.Configure(unit_file)

            file = self.global_conf.get("conf", "idea") 
            idea_file = abs_path + path + file
            self.idea_conf = configure.Configure(idea_file)

            file = self.global_conf.get("conf", "winfo") 
            winfo_file = abs_path + path + file
            self.winfo_conf = configure.Configure(winfo_file)

            file = self.global_conf.get("conf", "model") 
            model_file = abs_path + path + file
            self.model_conf = configure.Configure(model_file)

        except Exception as e:
            utils.print_exception(e, __file__)
            self.init_default()
        
    def init_default(self):
        """
        init with default values
        """
        self.global_conf = \
                configure.Configure(globals.DEFAULT_GLOBAL_CONF_FILENAME)
    
        # 初始化conn_type
        self.conn_type = globals.DEFAULT_CONN_TYPE 

        # 初始化log_file
        self.log_file = globals.DEFAULT_LOG_FILENAME

        # 初始化ConnectionGroups
        self.urls = []
        self.ports = []
        self.timeouts = []
        self.conn_group_num = globals.DEFAULT_CONN_GROUP_NUM
        self.urls = globals.DEFAULT_URLS
        self.ports = globals.DEFAULT_PORTS
        self.timeouts = globals.DEFAULT_TIMEOUTS

        # 初始化各model的conf
        self.plan_conf = \
                configure.Configure(globals.DEFAULT_PLAN_CONF_FILENAME)

        self.unit_conf = \
                configure.Configure(globals.DEFAULT_UNIT_CONF_FILENAME)

        self.idea_conf = \
                configure.Configure(globals.DEFAULT_IDEA_CONF_FILENAME)

        self.winfo_conf = \
                configure.Configure(globals.DEFAULT_WINFO_CONF_FILENAME)

        self.model_conf = \
                configure.Configure(globals.DEFAULT_MODEL_CONF_FILENAME)

"""
/* vim: set ts=4 sw=4 sts=4 tw=100 */
"""
