# -*- coding: utf-8 -*-
"""
/***************************************************************************
 * 
 * Copyright (c) 2015 Baidu.com, Inc. All Rights Reserved
 * $Id$ 
 * 
 **************************************************************************/
 
 
 
/**
 * @file winfo.py
 * @author daiwenkai(daiwenkai@baidu.com)
 * @date 2015/01/06 18:26:28
 * @version $Revision$ 
 * @brief 
 *  
 **/
"""

import sys
import os
os.sys.path.append(os.path.dirname(os.path.abspath(__file__))+"/../")

import models.model as model
import tools.utils as utils
import globals.globals as globals

class Winfo(model.Model):
    """
    Winfo
    """

    def __init__(self):
        """
        init
        """
        super(Winfo, self).__init__()

        self.init_configs()

        model.Model.create_conn(self)

    def init_configs(self):
        """
        init configs: connection, service, method
        """
        self.init_conf_service_method()

    def init_conf_service_method(self):
        """
        init conf service & method
        """
        try:
            mod_section = "WinfoModAPI"
            self.service_mod = self.conn.conf.winfo_conf.get(mod_section, "service")
            self.method_addWinfo = self.conn.conf.winfo_conf.get(mod_section, "method_addWinfo")
            self.method_modWinfo = self.conn.conf.winfo_conf.get(mod_section, "method_modWinfo")
            self.method_modWinfoPause = \
                    self.conn.conf.winfo_conf.get(mod_section, "method_modWinfoPause")
            self.method_modWinfoBid = \
                    self.conn.conf.winfo_conf.get(mod_section, "method_modWinfoBid")
            self.method_modWinfoWmatch = \
                    self.conn.conf.winfo_conf.get(mod_section, "method_modWinfoWmatch")
            self.method_modWinfoWctrl = \
                    self.conn.conf.winfo_conf.get(mod_section, "method_modWinfoWctrl")
            self.method_delWinfo = self.conn.conf.winfo_conf.get(mod_section, "method_delWinfo")

            query_section = "WinfoQueryAPI"
            self.service_query = self.conn.conf.winfo_conf.get(query_section, "service")
            self.method_queryWinfo = \
                    self.conn.conf.winfo_conf.get(query_section, "method_queryWinfo")
        except Exception as e:
            utils.print_exception(e, __file__)
            self.service_mod = globals.DEFAULT_WINFO_SERVICE_MOD 
            self.method_addWinfo = globals.DEFAULT_WINFO_METHOD_ADD_WINFO 
            self.method_modWinfo = globals.DEFAULT_WINFO_METHOD_MOD_WINFO 
            self.method_modWinfoPause = globals.DEFAULT_WINFO_METHOD_MOD_WINFO_PAUSE 
            self.method_modWinfoBid = globals.DEFAULT_WINFO_METHOD_MOD_WINFO_BID 
            self.method_modWinfoWmatch = globals.DEFAULT_WINFO_METHOD_MOD_WINFO_WMATCH 
            self.method_modWinfoWctrl = globals.DEFAULT_WINFO_METHOD_MOD_WINFO_WCTRL 
            self.method_delWinfo = globals.DEFAULT_WINFO_METHOD_DEL_WINFO 

            self.service_query = globals.DEFAULT_WINFO_SERVICE_QUERY
            self.method_queryWinfo = globals.DEFAULT_WINFO_METHOD_QUERY_WINFO 

    def add_winfo(self, params):
        """
        add_winfo:
        service: /WinfoModAPIProxy
        method: addWord
        新增winfo
        【params】:
        (userid,[{"unitid":1234567, "showword":"美索不达米亚", "bid":777.7, "wmatch":31,
        "wurl":"http://www.tyrannosaur.com", "pausestat":0}, ...])
        【必传参数】：
        userid, unitid, showword
        【选填参数】：
        bid, wmatch, wurl, pausestat等
        【备注】：
        不建议在添加winfo时设置pausestat参数，因为启动暂停状态不完全取决于客户自己的设置。pausestat=0,1
        showword只能添加,不能修改
        """
        ret = utils.check_params_length(params, 2, "add_winfo")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]

        res = self.process(self.service_mod, self.method_addWinfo, params)
        self.print_res_info(res)
        
        return res

    def mod_winfo(self, params):
        """
        mod_winfo:
        service: /WordModAPIProxy
        method: modWord
        修改winfo
        【params】:
        (userid, [{"winfoid":654321, "items":{"bid":1.0, "wmatch":31, "pausestat":true}},
        ...,{"winfoid":7654321, "items":{"bid":1.1, "wmatch":15, "pausestat":false}}])
        【必传参数】：
        userid, winfoid, items(可以为空)
        【选填参数】：
        无
        【备注】：
        可以改bid, wmatch, pausestat
        pausestat=False/True
        showword只能添加,不能修改。
        """
        ret = utils.check_params_length(params, 2, "mod_winfo")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]
        # 检查showword是否在修改请求中
        ret = utils.check_mod_keys_valid(params, "mod_winfo", "showword")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]


        res = self.process(self.service_mod, self.method_modWinfo, params)

        self.print_res_info(res)

        return res

    def mod_winfo_pause(self, params):
        """
        mod_winfo_pause:
        service: /WordModAPIProxy
        method: modWordPausestat 
        修改启动暂停状态
        【params】:
        (userid, (winfoid1, winfoid2, ...,winfoidN), pausestat)  
        (pausestat取值: True暂停; False启动)

        【必传参数】：
        userid, winfoids, pausestat
        【选填参数】：
        无
        【备注】：
        """
        ret = utils.check_params_length(params, 3, "mod_winfo_pause")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]

        valid_pausestat = [True, False]
        pausestat = params[2]
        # 判断pausestat是否符合预期
        if pausestat not in valid_pausestat:
            res = utils.set_default_res("pausestat", pausestat, valid_pausestat)
            self.print_res_info(res)
            return res

        res = self.process(self.service_mod, self.method_modWinfoPause, params)

        self.print_res_info(res)

        return res

    def mod_winfo_bid(self, params):
        """
        mod_winfo_bid:
        service: /WordModAPIProxy
        method: modWordBid
        修改bid
        【params】:
        (userid, (winfoid1, winfoid2, ...,winfoidN), bid)  
        (bid为double类型, 范围(0, 999.99])

        【必传参数】：
        userid, winfoids, bid
        【选填参数】：
        无
        【备注】：
        """
        ret = utils.check_params_length(params, 3, "mod_winfo_bid")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]

        res = self.process(self.service_mod, self.method_modWinfoBid, params)

        self.print_res_info(res)

        return res

    def mod_winfo_wmatch(self, params):
        """
        mod_winfo_wmatch:
        service: /WordModAPIProxy
        method: modWordWmatch
        修改wmatch
        【params】:
        (userid, (winfoid1, winfoid2, ...,winfoidN), wmatch) 
        (wmatch取值: 63:精确, 31:短语, 15:广泛)

        【必传参数】：
        userid, winfoids, wmatch
        【选填参数】：
        无
        【备注】：
        """
        ret = utils.check_params_length(params, 3, "mod_winfo_wmatch")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]

        valid_wmatch = [63, 31, 15]
        wmatch = params[2]
        # 判断wmatch是否符合预期
        if wmatch not in valid_wmatch:
            res = utils.set_default_res("wmatch", wmatch, valid_wmatch)
            self.print_res_info(res)
            return res

        res = self.process(self.service_mod, self.method_modWinfoWmatch, params)

        self.print_res_info(res)

        return res

    def mod_winfo_wctrl(self, params):
        """
        mod_winfo_wctrl:
        service: /WordModAPIProxy
        method: modWordWctrl
        修改wctrl
        【params】:
        (userid, (winfoid1, winfoid2, ...,winfoidN), wctrl) 
        (wctrl取值: 0:同义包含, 1:精确包含, 3:核心包含)

        【必传参数】：
        userid, winfoids, wctrl
        【选填参数】：
        无
        【备注】：
        wctrl=0时，adcore返回true
        wctrl=1,3时，adcore返回false 
        但db中会写入要修改的真实值
        """
        ret = utils.check_params_length(params, 3, "mod_winfo_wctrl")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]
        valid_wctrl = [0, 1, 3]
        wctrl = params[2]
        # 判断wctrl是否符合预期
        if wctrl not in valid_wctrl:
            res = utils.set_default_res("wctrl", wctrl, valid_wctrl)
            self.print_res_info(res)
            return res

        res = self.process(self.service_mod, self.method_modWinfoWctrl, params)

        self.print_res_info(res)

        return res

    def del_winfo(self, params):
        """
        del_winfo:
        service: /WordModAPIProxy
        method: delWord
        删除winfo
        【params】:
        (userid, (winfoid1, winfoid2, ...,winfoidN))

        【必传参数】：
        userid, winfoids
        【选填参数】：
        无
        【备注】：
        """
        ret = utils.check_params_length(params, 2, "del_winfo")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]

        res = self.process(self.service_mod, self.method_delWinfo, params)

        self.print_res_info(res)

        return res

    def query_winfo(self, params):
        """
        query_winfo:
        service: /WordQueryAPIProxy
        method: getWord
        查询winfo
        【params】:
        (userid, {"planid":(planid1, planid2, ..., planidN), "unitid":(unitid1, unitid2, ..., unitidN), "winfoid":(winfoid1, winfoid2, ..., winfoidN), "fields":["showword", "pausestat", "bid", "wurl", "wmatch", "wctrl", ...]})

        【必传参数】：
        userid必填。planid, unitid, winfoid为或的关系，至少要填一个
        【选填参数】：
        fields中的字段 
        【备注】：
        返回时，非查询的field会返回null
        若填了多个层级的id，adcore只按最下层的id去查询(忽略掉高层级的id)(如填了planid, unitid, winfoid, 只看winfoid)
        """
        ret = utils.check_params_length(params, 2, "query_winfo")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]

        res = self.process(self.service_query, self.method_queryWinfo, params)

        self.print_res_info(res)

        return res

"""
/* vim: set ts=4 sw=4 sts=4 tw=100 */
"""
