# -*- coding: utf-8 -*-
"""
/***************************************************************************
 * 
 * Copyright (c) 2015 Baidu.com, Inc. All Rights Reserved
 * $Id$ 
 * 
 **************************************************************************/
 
 
 
/**
 * @file unit.py
 * @author daiwenkai(daiwenkai@baidu.com)
 * @date 2015/01/06 18:26:28
 * @version $Revision$ 
 * @brief 
 *  
 **/
"""

import sys
import os
os.sys.path.append(os.path.dirname(os.path.abspath(__file__))+"/../")

import models.model as model
import tools.utils as utils
import globals.globals as globals

class Unit(model.Model):
    """
    Unit
    """

    def __init__(self):
        """
        init
        """
        super(Unit, self).__init__()

        self.init_configs()

        model.Model.create_conn(self) #, self.url, self.port, self.timeout)

    def init_configs(self):
        """
        init configs: service, method
        """
        self.init_conf_service_method()

    def init_conf_service_method(self):
        """
        init conf service & method
        """
        try:
            mod_section = "UnitModAPI"
            self.service_mod = self.conn.conf.unit_conf.get(mod_section, "service")
            self.method_addUnit = self.conn.conf.unit_conf.get(mod_section, "method_addUnit")
            self.method_modUnit = self.conn.conf.unit_conf.get(mod_section, "method_modUnit")

        except Exception as e:
            utils.print_exception(e, __file__)
            self.service_mod = globals.DEFAULT_UNIT_SERVICE_MOD 
            self.method_addUnit = globals.DEFAULT_UNIT_METHOD_ADD_UNIT
            self.method_modUnit = globals.DEFAULT_UNIT_METHOD_MOD_UNIT 

    def add_unit(self, params):
        """
        add_unit:
        service: /UnitModAPIProxy
        method: addUnit
        新增unit
        【params】:
        (userid,[{"planid":  planid, "unitname":"xxxx", "unitbid":1.22},...])

        【必传参数】：
        userid, planid, unitname, unitbid
        unitbid范围：(0,1000)
        【选填参数】：
        无 
        【备注】：
        【还可以指定mpricefactor，但express项目并无此需求】
        """
        ret = utils.check_params_length(params, 2, "add_unit")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]

        res = self.process(self.service_mod, self.method_addUnit, params)
        self.print_res_info(res)

        return res

    def mod_unit(self, params):
        """
        【此接口开放，但express项目并无此需求】
        mod_unit:
        service: /UnitModAPIProxy
        method: modUnit
        修改unit的mpricefactor
        【params】:
        (userid, [{"unitid":654321, "items":{"mpricefactor":2.3 }},
        ...,])

        【必传参数】：
        userid, unitid, mpricefactor
        mpricefactor的范围：[0,10]
        【选填参数】：
        无 
        【备注】：
        专门用于修改mpricefactor
        """
        ret = utils.check_params_length(params, 2, "mod_unit")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]

        res = self.process(self.service_mod, self.method_modUnit, params)
        self.print_res_info(res)

        return res

"""
/* vim: set ts=4 sw=4 sts=4 tw=100 */
"""
