# -*- coding: utf-8 -*-
"""
/***************************************************************************
 * 
 * Copyright (c) 2015 Baidu.com, Inc. All Rights Reserved
 * $Id$ 
 * 
 **************************************************************************/
 
 
 
/**
 * @file plan.py
 * @author daiwenkai(daiwenkai@baidu.com)
 * @date 2015/01/06 18:26:28
 * @version $Revision$ 
 * @brief 
 *  
 **/
"""

import sys
import os
import logging

os.sys.path.append(os.path.dirname(os.path.abspath(__file__))+"/../")

import models.model as model
import tools.log as log
import tools.utils as utils
import globals.globals as globals

class Plan(model.Model):
    """
    Plan
    """

    def __init__(self):
        """
        init
        """
        super(Plan, self).__init__()

        self.init_configs()

        model.Model.create_conn(self)

    def init_configs(self):
        """
        init configs: service, method
        """
        self.init_conf_service_method()

    def init_conf_service_method(self):
        """
        init conf service & method
        """
        try:
            mod_section = "PlanModAPI"
            self.service_mod = self.conn.conf.plan_conf.get(mod_section, "service")
            self.method_addPlan = self.conn.conf.plan_conf.get(mod_section, "method_addPlan")
            self.method_modPlan = self.conn.conf.plan_conf.get(mod_section, "method_modPlan")
            self.method_modPlanWbudget = \
                    self.conn.conf.plan_conf.get(mod_section, "method_modPlanWbudget")
            self.method_modPlanWregion= \
                    self.conn.conf.plan_conf.get(mod_section, "method_modPlanWregion")
            self.method_modPlanCyc = self.conn.conf.plan_conf.get(mod_section, "method_modPlanCyc")

            query_section = "PlanQueryAPI"
            self.service_query = self.conn.conf.plan_conf.get(query_section, "service")
            self.method_queryPlan = self.conn.conf.plan_conf.get(query_section, "method_queryPlan")
        except Exception as e:
            utils.print_exception(e, __file__)
            self.service_mod = globals.DEFAULT_PLAN_SERVICE_MOD 
            self.method_addPlan = globals.DEFAULT_PLAN_METHOD_ADD_PLAN 
            self.method_modPlan = globals.DEFAULT_PLAN_METHOD_MOD_PLAN 
            self.method_modPlanWbudget = globals.DEFAULT_PLAN_METHOD_MOD_PLAN_WBUDGET 
            self.method_modPlanWregion= globals.DEFAULT_PLAN_METHOD_MOD_PLAN_WREGION 
            self.method_modPlanCyc = globals.DEFAULT_PLAN_METHOD_MOD_PLAN_CYC 

            self.service_query = globals.DEFAULT_PLAN_SERVICE_QUERY
            self.method_queryPlan = globals.DEFAULT_PLAN_METHOD_QUERY_PLAN 

    def add_plan(self, params):
        """
        add_plan:
        service: /PlanModAPIProxy
        method: addPlan
        新增plan
        【params】:
        (userid,[{"planname":"name1", "deviceprefer":0}, {"planname":"name2",
        "deviceprefer":1},...,{"planname":"nameN", "deviceprefer":2}])

        【必传参数】：
        userid, planname
        【选填参数】：
        deviceprefer(0:All，1:PC，2:移动)
        【备注】：
        deviceprefer为选填，【但只有在添加时可以设置】
        """
        ret = utils.check_params_length(params, 2, "add_plan")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]

        res = self.process(self.service_mod, self.method_addPlan, params)
        
        self.print_res_info(res)

        return res

    def mod_plan(self, params):
        """
        mod_plan:
        service: /PlanModAPIProxy
        method: modPlan
        修改plan
        【params】:
        (userid, [{"planid":654321, "items":{"planname":"xxx", "wbudget":31.2, "plancyc":[8*25]}},
        ...,{"planid":654321, "items":{"planname":"xxx", "wbudget":31.2, "plancyc":[8*25]}}])
        【必传参数】：
        userid, planid, items(可以为空) 
        【选填参数】：
        无 
        【备注】：
        plancyc定义见mod_plan_cyc
        不能设置deviceprefer。
        """
        ret = utils.check_params_length(params, 2, "mod_plan")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]
        # 检查deviceprefer是否在修改请求中
        ret = utils.check_mod_keys_valid(params, "mod_plan", "deviceprefer")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]
   
        res = self.process(self.service_mod, self.method_modPlan, params)

        self.print_res_info(res)

        return res

    def mod_plan_wbudget(self, params):
        """
        mod_plan_wbudget:
        service: /PlanModAPIProxy
        method: modPlanWbudget
        修改plan的wbudget
        【params】:
        (userid,(planid1, planid2 , ...,planidN), wbudget) 
        【必传参数】：
        userid, planids, wbudget
        【选填参数】：
        无 
        【备注】：
        planids是集合，如有重复，返回的是去重后的结果
        wbudget可以是double或者int,范围[50,1000000]
        """
        ret = utils.check_params_length(params, 3, "mod_plan_wbudget")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]

        res = self.process(self.service_mod, self.method_modPlanWbudget, params)

        self.print_res_info(res)

        return res

    def mod_plan_wregion(self, params):
        """
        mod_plan_wregion:
        service: /PlanModAPIProxy
        method: modPlanWregion
        将所有planid的wregion都设为同一个地域列表
        【params】:
        (userid,(planid1, planid2 , ...,planidN), [wregion1, wregion2, ...]) 

        【必传参数】：
        userid, planids, wregions
        【选填参数】：
        无 
        【备注】：
        planids是集合，如有重复，返回的是去重后的结果
        默认是null(传参时可以传None或者[])，即选择所有地域。其他的可以传省级/城市级的数据。具体地域编码见附件region.map
        """
        ret = utils.check_params_length(params, 3, "mod_plan_wregion")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]

        res = self.process(self.service_mod, self.method_modPlanWregion, params)

        self.print_res_info(res)

        return res

    def mod_plan_cyc(self, params):
        """
        mod_plan_cyc:
        service: /PlanModAPIProxy
        method: modPlancyc
        将所有planid的cyc都设为同一个
        【params】:
        (userid,(planid1, planid2 , ...,planidN), [8*25数组])  

        【必传参数】：
        userid, planids, cyc
        【选填参数】：
        无 
        【备注】：
        cyc的定义见附件cyc.txt
        """
        ret = utils.check_params_length(params, 3, "mod_plan_cyc")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]
        res = self.process(self.service_mod, self.method_modPlanCyc, params)

        self.print_res_info(res)

        return res

    def query_plan(self, params):
        """
        query_plan:
        service: /PlanQueryAPIProxy
        method: getPlan
        查询plan
        【params】:
        (userid, {"planid":(planid1, planid2, ..., planidN), "fields":["wbudget", "wregion", "plancyc",
...]})

        【必传参数】：
        userid, planid
        fields数组不空
        【选填参数】：
        无 
        【备注】：
        """
        ret = utils.check_params_length(params, 2, "query_plan")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]

        res = self.process(self.service_query, self.method_queryPlan, params)

        self.print_res_info(res)

        return res

"""
/* vim: set ts=4 sw=4 sts=4 tw=100 */
"""
