# -*- coding: utf-8 -*-
"""
/***************************************************************************
 * 
 * Copyright (c) 2015 Baidu.com, Inc. All Rights Reserved
 * $Id$ 
 * 
 **************************************************************************/
 
 
 
/**
 * @file model.py
 * @author daiwenkai(daiwenkai@baidu.com)
 * @date 2015/01/06 18:26:28
 * @version $Revision$ 
 * @brief 
 *  
 **/
"""

import logging
import json

import os
os.sys.path.append(os.path.dirname(os.path.abspath(__file__))+"/../")

import connections.connectionmgr as connectionmgr
import connections.httpmcpackmgr as httpmcpackmgr
import tools.log as log
import globals.globals as globals

class Model(object):
    """
    Model
    所有表的基类
    """

    def __init__(self):
        """
        init
        依据不同conn_type对self.conn进行初始化
        """
        self.mgr = connectionmgr.ConnectionMgr()
        res = self.mgr.set_conn_group()
        self.url = res[0] 
        self.port = res[1] 
        self.timeout = res[2] 
        if self.mgr.conf.conn_type == "HttpMcpackMgr":
            self.conn = httpmcpackmgr.HttpMcpackMgr()
        # TODO: 如果是其他类型的conn_type，
        # 则使用其他类对self.conn进行初始化

    def create_conn(self):
        """
        create_connon
        创建一个连接，由self.conn所属的类型具体实现
        """
        ret = self.conn.create_conn(self.url, self.port, self.timeout) 
        info = "connecting %s:%d" % (self.url, self.port)
        logging.debug(info)
 
    def process(self, service, method, params):
        """
        process
        调用self.conn的get_response函数，返回结果为
        res_info, res_err_detail, res_data三元组
        """
        res = self.conn.get_response(service, method, params)

        return res

    def print_res_info(self, res):
        """
        print_res_info: 
        将res_info, err_detail, data打印出来
        """
        res_info = res[0]
        logging.info("res_info: ")
        logging.info(str(res_info))
        res_err_detail = res[1]
        logging.info("err_detail: ")
        logging.info(res_err_detail)
        res_data = res[2]
        logging.info("data: ")
        logging.info(res_data)

"""
/* vim: set ts=4 sw=4 sts=4 tw=100 */
"""
