# -*- coding: utf-8 -*-
"""
/***************************************************************************
 * 
 * Copyright (c) 2015 Baidu.com, Inc. All Rights Reserved
 * $Id$ 
 * 
 **************************************************************************/
 
 
 
/**
 * @file idea.py
 * @author daiwenkai(daiwenkai@baidu.com)
 * @date 2015/01/06 18:26:28
 * @version $Revision$ 
 * @brief 
 *  
 **/
"""

import sys
import os
os.sys.path.append(os.path.dirname(os.path.abspath(__file__))+"/../")

import models.model as model
import globals.globals as globals
import tools.utils as utils

class Idea(model.Model):
    """
    Idea
    """

    def __init__(self):
        """
        init
        """
        super(Idea, self).__init__()

        self.init_configs()

        model.Model.create_conn(self)
        
    def init_configs(self):
        """
        init configs: service, method
        """
        self.init_conf_service_method()

    def init_conf_service_method(self):
        """
        init conf service & method
        """
        try:
            mod_section = "IdeaModAPI"
            self.service_mod = self.conn.conf.idea_conf.get(mod_section, "service")
            self.method_addIdea = self.conn.conf.idea_conf.get(mod_section, "method_addIdea")
            self.method_modIdea = self.conn.conf.idea_conf.get(mod_section, "method_modIdea")

            query_section = "IdeaQueryAPI"
            self.service_query = self.conn.conf.idea_conf.get(query_section, "service")
            self.method_queryIdea = self.conn.conf.idea_conf.get(query_section, "method_queryIdea")
        except Exception as e:
            utils.print_exception(e, __file__)
            self.service_mod = globals.DEFAULT_IDEA_SERVICE_MOD 
            self.method_addIdea = globals.DEFAULT_IDEA_METHOD_ADD_IDEA 
            self.method_modIdea = globals.DEFAULT_IDEA_METHOD_MOD_IDEA 

            self.service_query = globals.DEFAULT_IDEA_SERVICE_QUERY
            self.method_queryIdea = globals.DEFAULT_IDEA_METHOD_QUERY_IDEA 

    def add_idea(self, params):
        """
        add_idea:
        service: /IdeaModAPIProxy
        method: addIdea
        新增idea
        【params】:
        (userid,[{"unitid":1234567, "title":"your title", "desc1":"描述1", "desc2":"描述2", "url":"http://www.tyrannosaur.com", "showurl":"http://www.tyrannosaur.com", "miurl":"http://mobile.tyrannosaur.com", "mshowurl":"http://mobile.tyrannosaur.com"}, ...])

        【必传参数】：
        userid, unitid, title, desc1, desc2, url, showurl
        其中，title, desc1, desc2都必须是9-50个字符
        url, showurl必须的域名必须与注册网站一致
        （如测试用户630152是http://www.china356.com/）
        【选填参数】
        miurl, mshowurl等
        【备注】：
        url即landingpage，还有miurl,mshowurl可以设置，为移动的url
        title中不能含有"le10"字样，否则会被aka过滤。如"title10"即不合法
        """
        ret = utils.check_params_length(params, 2, "add_idea")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]

        res = self.process(self.service_mod, self.method_addIdea, params)
        self.print_res_info(res)

        return res

    def mod_idea(self, params):
        """
        mod_idea:
        service: /IdeaModAPIProxy
        method: modIdea
        修改idea
        【params】:
        (userid, [{"ideaid":123456, "title":"title1","desc1":"cygnus","showurl":"http://www.cygnus.org","url":"http://www.cygnus.org"},...,{"ideaid":1234567, "title":"title2", "desc1":"pegasus","showurl":"http://www.pegasus.org"}])

        【必传参数】：
        userid, unitid, title, desc1, desc2, url, showurl
        同add_idea
        【选填参数】
        miurl, mshowurl等
        【备注】：
        修改字段里如果没有title,那么其它的那4个字段就算修改,也无效(如果只修改desc1,结果会返回200,但desc1的值还是原来的)
        如果修改title,你就要保证其它4个字段都是你想要的最新的值,否则报错
        故，如果只想修改某一两个字段而保持其他的不变，必须先通过queryIdea获得不修改的其他字段
        """
        ret = utils.check_params_length(params, 2, "mod_idea")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]

        res = self.process(self.service_mod, self.method_modIdea, params)
        self.print_res_info(res)

        return res

    def query_idea(self, params):
        """
        query_idea:
        service: /IdeaQueryAPIProxy
        method: getIdea
        查询idea
        【params】:
        (userid, {"planid":(planid1, planid2, ..., planidN), "unitid":(unitid1, unitid2, ..., unitidN),"ideaid":(ideaid1, ideaid2, ..., ideaidN), "fields":["title", "desc1", "desc2", "url", "showurl",...]})

        【必传参数】：
        userid必填。planid, unitid, ideaid为或的关系，至少要填一个
        【选填参数】：  
        fields中的字段
        【备注】：
        返回时，非查询的field会返回null
        若填了多个层级的id，adcore只按最下层的id去查询(忽略掉高层级的id)
         (如填了planid, unitid, ideaid, 只看ideaid)
        """
        ret = utils.check_params_length(params, 2, "query_idea")
        if False == ret[0]:
            self.print_res_info(ret[1])
            return ret[1]

        res = self.process(self.service_query, self.method_queryIdea, params)

        self.print_res_info(res)

        return res

"""
/* vim: set ts=4 sw=4 sts=4 tw=100 */
"""
