# -*- coding: GB18030 -*-
# # '''
# # Created on Dec 11, 2011
# # @author: maqi<maqi@baidu.com>
# # @summary: nshead lib
# # '''

import struct

class nshead:

    format = "HHI16sIII"
    magic_num = 0xfb709394

    def __init__(self, head={}):
        self.head = {}
        self.head["id"] = head.get("id",0)
        self.head["version"] = head.get("version",0)
        self.head["log_id"] = head.get("log_id",0)
        self.head["provider"] = head.get("provider","pynshead")
        self.head["magic_num"] = self.magic_num
        self.head["reserved"] = head.get("reserved",0)
        self.head["body_len"] = head.get("body_len",0)
        self.struct = struct.Struct(self.format)
        self.size = self.struct.size

    def load(self, bin):
        (self.head["id"], self.head["version"], self.head["log_id"], self.head["provider"], self.head["magic_num"],
                self.head["reserved"], self.head["body_len"]) = self.struct.unpack(bin)
        if self.head["magic_num"] != self.magic_num:
            raise UserWarning("magic_num check fail")
        
    def save(self):
        return self.struct.pack(self.head["id"], self.head["version"], self.head["log_id"],
                self.head["provider"], self.head["magic_num"], self.head["reserved"], self.head["body_len"])

