# -*- coding: GB18030 -*-
# # '''
# # Created on Dec 11, 2011
# # @author: maqi<maqi@baidu.com>
# # @summary: mchead lib 
# # '''

import struct

class mchead(object):
    format = "IIII"

    def __init__(self, head={}):
        self.head = {}
        self.head["version"] = head.get("version",0)
        self.head["secruit_id"] = head.get("secruit_id",0)
        self.head["req_type"] = head.get("req_type",0)
        self.head["mc_pack_len"] = head.get("mc_pack_len",0)
                
        self.struct = struct.Struct(self.format)
        self.size = self.struct.size

    def load(self,data):
        (self.head["version"],self.head["secruit_id"],self.head["req_type"],self.head["mc_pack_len"]) = self.struct.unpack(data)

    def save(self):
        return self.struct.pack(self.head["version"], self.head["secruit_id"], self.head["req_type"],self.head["mc_pack_len"])

