# -*- coding: utf-8 -*-
"""
/***************************************************************************
 * 
 * Copyright (c) 2015 Baidu.com, Inc. All Rights Reserved
 * $Id$ 
 * 
 **************************************************************************/
 
 
 
/**
 * @file globals.py
 * @author daiwenkai(daiwenkai@baidu.com)
 * @date 2015/01/14 22:29:46
 * @version $Revision$ 
 * @brief 
 *  
 **/
"""

import os
os.sys.path.append(os.path.dirname(os.path.abspath(__file__))+"/../")

abs_path = os.path.dirname("/home/users/daiwenkai/")
#abs_path = os.path.dirname(os.path.abspath(__file__)) + "/../../"


##################################### 线上/线下配置开关 ######################
# flag取值：
# ON: 线上配置
# OFF: 线下配置
flag_on_off = "ON"

##################################### HttpMcpackMgr的返回状态 ######################

#**** ADCORE正常的返回状态 ****

# 200: 成功
STATUS_SUCCESS = 200
# 300: 部分成功，批量操作，只有部分成功
STATUS_PARTIAL_SUCCESS = 300
# 400: 失败
STATUS_FAIL = 400

#**** ADCORE异常的返回状态 ****

# mcpack-rpc的错误信息
# 请求包格式出错等情况
STATUS_EXTERNAL_ERR = -1

# 返回包不是mcpack形式
# 分以下两种情况：
# 1.由于是http请求，所以返回的是一个404之类的html页面,返回结果中有<body>
#   出现此情况的原因一般是service(如/WinfoModAPIProxy)不存在
# 2.如果是服务有问题等情况，则返回结果会是空串
STATUS_EXTERNAL_ERR_HTML = -2

# 连接出错等情况
# 如，端口\IP错误或者服务没有正常开启等导致的create_conn失败
# 也可能是连接超时引起的
STATUS_SERVER_CONN_ERR = -3

# 请求包的params出错
STATUS_REQ_PARAMS_ERR = -4

# 请求包包含invalid key
STATUS_REQ_PARAMS_INVALID_KEY_ERR = -5

##################################### DEFAULT VALUES ######################

### THREADING

# 默认的时间间隔,用于demo.py调节qps
DEFAULT_TIME_INTERVAL = 0.8
DEFAULT_THREAD_NUM = 5

### CONFIGURES

DEFAULT_CONF_PATH = "/conf/"
DEFAULT_LOG_PATH = "/log/"

if "ON" == flag_on_off:
    # 使用线上配置
    DEFAULT_GLOBAL_CONF_FILENAME = abs_path + DEFAULT_CONF_PATH + "global.conf"
else:
    # 使用线下配置
    DEFAULT_GLOBAL_CONF_FILENAME = abs_path + DEFAULT_CONF_PATH + "global_off.conf"

DEFAULT_LOG_FILENAME = abs_path + DEFAULT_LOG_PATH + "express_global"
DEFAULT_PLAN_CONF_FILENAME = abs_path + DEFAULT_CONF_PATH + "plan.conf"
DEFAULT_UNIT_CONF_FILENAME = abs_path + DEFAULT_CONF_PATH + "unit.conf"
DEFAULT_IDEA_CONF_FILENAME = abs_path + DEFAULT_CONF_PATH + "idea.conf"
DEFAULT_WINFO_CONF_FILENAME = abs_path + DEFAULT_CONF_PATH + "winfo.conf"
DEFAULT_MODEL_CONF_FILENAME = abs_path + DEFAULT_CONF_PATH + "model.conf"
DEFAULT_CONN_TYPE = "HttpMcpackMgr"

### CONNECTIOINS
if "ON" == flag_on_off:
    # 线上配置
    DEFAULT_CONN_GROUP_NUM = 2
    DEFAULT_URLS = []
    DEFAULT_URLS.append("10.36.4.102")
    DEFAULT_URLS.append("10.81.211.204")
    DEFAULT_PORT = 8086
    DEFAULT_TIMEOUT = 30
    DEFAULT_PORTS = []
    DEFAULT_TIMEOUTS = []
    for i in xrange(0, DEFAULT_CONN_GROUP_NUM):
        DEFAULT_PORTS.append(DEFAULT_PORT)
        DEFAULT_TIMEOUTS.append(DEFAULT_TIMEOUT)
else:
    # 线下配置
    DEFAULT_CONN_GROUP_NUM = 3
    DEFAULT_URLS = []
    DEFAULT_URLS.append("10.48.244.92")
    DEFAULT_URLS.append("10.95.130.38")
    DEFAULT_URLS.append("10.95.192.204")
    DEFAULT_PORT = 8086
    DEFAULT_TIMEOUT = 30
    DEFAULT_PORTS = []
    DEFAULT_TIMEOUTS = []
    DEFAULT_PORTS.append(DEFAULT_PORT)
    DEFAULT_PORTS.append(DEFAULT_PORT)
    DEFAULT_PORTS.append(8101)
    for i in xrange(0, DEFAULT_CONN_GROUP_NUM):
        DEFAULT_TIMEOUTS.append(DEFAULT_TIMEOUT)

### PLAN
DEFAULT_PLAN_SERVICE_MOD = "/PlanModAPIProxy"
DEFAULT_PLAN_SERVICE_QUERY = "/PlanQueryAPIProxy"
DEFAULT_PLAN_METHOD_ADD_PLAN = "addPlan"
DEFAULT_PLAN_METHOD_MOD_PLAN = "modPlan"
DEFAULT_PLAN_METHOD_MOD_PLAN_WBUDGET = "modPlanWbudget"
DEFAULT_PLAN_METHOD_MOD_PLAN_WREGION = "modPlanWregion"
DEFAULT_PLAN_METHOD_MOD_PLAN_CYC = "modPlancyc"
DEFAULT_PLAN_METHOD_QUERY_PLAN = "getPlan"

### UNIT
DEFAULT_UNIT_SERVICE_MOD = "/UnitModAPIProxy"
DEFAULT_UNIT_METHOD_ADD_UNIT = "addUnit"
DEFAULT_UNIT_METHOD_MOD_UNIT = "modUnit"

### IDEA 
DEFAULT_IDEA_SERVICE_MOD = "/IdeaModAPIProxy"
DEFAULT_IDEA_SERVICE_QUERY = "/IdeaQueryAPIProxy"
DEFAULT_IDEA_METHOD_ADD_IDEA = "addIdea"
DEFAULT_IDEA_METHOD_MOD_IDEA = "modIdea"
DEFAULT_IDEA_METHOD_QUERY_IDEA = "getIdea"

### WINFO 
DEFAULT_WINFO_SERVICE_MOD = "/WordModAPIProxy"
DEFAULT_WINFO_SERVICE_QUERY = "/WordQueryAPIProxy"
DEFAULT_WINFO_METHOD_ADD_WINFO = "addWord"
DEFAULT_WINFO_METHOD_MOD_WINFO = "modWord"
DEFAULT_WINFO_METHOD_MOD_WINFO_PAUSE = "modWordPause"
DEFAULT_WINFO_METHOD_MOD_WINFO_BID = "modWordBid"
DEFAULT_WINFO_METHOD_MOD_WINFO_WMATCH= "modWordWmatch"
DEFAULT_WINFO_METHOD_MOD_WINFO_WCTRL = "modWordWctrl"
DEFAULT_WINFO_METHOD_DEL_WINFO = "delWord"
DEFAULT_WINFO_METHOD_QUERY_WINFO = "getWord"

"""
/* vim: set ts=4 sw=4 sts=4 tw=100 */
"""
