# -*- coding: utf-8 -*-
from base import Base
from parser import *

class UserData(Base):
    def __init__(self, soup):
        self._id = soup.user['id']
        self._external_profile_id = soup.user['externalprofileid']
        self._gender = soup.user.gender.text
        self._email = soup.user.email.text
        self._state = soup.user.state.text
        self._city = soup.user.city.text
        self._country = soup.user.country.text
        self._plusLevel = soup.user.pluslevel.text
        self._active_owned_callenge_count = int(soup.user.activeownedchallengecount.text)
        
        self._total_distance = float(soup.usertotals.totaldistance.text)
        self._total_duration = int(soup.usertotals.totalduration.text)
        self._total_runs_with_routes = int(soup.usertotals.totalrunswithroutes.text)
        self._total_runs_runs = int(soup.usertotals.totalruns.text)
        self._total_calories = float(soup.usertotals.totalcalories.text)
        self._total_workouts = float(soup.usertotals.totalworkouts.text)
        self._total_cardio_distance = float(soup.usertotals.totalcardiodistance.text)

        self._average_runs_per_week = float(soup.usertotals.averagerunsperweek.text)
        self._preferred_run_day_of_week = soup.usertotals.preferredrundayofweek.text
        self._pedo_workouts = int(soup.usertotals.pedoworkouts.text)
        self._total_steps = int(soup.usertotals.totalsteps.text)
        self._longest_step_count = int(soup.usertotals.longeststepcount.text)
        self._average_step_count = float(soup.usertotals.averagestepcount.text)
        self._calories_pedometer = int(soup.usertotals.caloriespedometer.text)
        self._total_calories_pedometer = int(soup.usertotals.totalcaloriespedometer.text)
        self._total_runs_with_heartrate = int(soup.usertotals.totalrunswithheartrate.text)
        self._total_heart_rate_only_activities = int(soup.usertotals.totalheartrateonlyactivities.text)
        self._previous_sync_time = parse_datetime(soup.usertotals.previoussynctime.text)
        self._last_calculated = parse_datetime(soup.usertotals.lastcalculated.text)
        
        self._screen_name = soup.useroptions.screenname.text
        self._distance_unit = soup.useroptions.distanceunit.text
        self._date_format = soup.useroptions.dateformat.text
        self._start_week = soup.useroptions.startweek.text
        self._avatar = soup.useroptions.avatar.text
        self._uploaded_avatar = soup.useroptions.uploadedavatar.text
        self._is_public = parse_boolean(soup.useroptions.ispublic.text)
        self._email_goal_ending = parse_boolean(soup.useroptions.emailgoalending.text)
        self._email_goal_complete = parse_boolean(soup.useroptions.emailgoalcomplete.text)
        self._email_weekly_training = parse_boolean(soup.useroptions.emailweeklytraining.text)
        self._email_challenge_ending = parse_boolean(soup.useroptions.emailchallengeending.text)
        self._email_challenge_starting = parse_boolean(soup.useroptions.emailchallengestarting.text)
        self._email_challenge_winner = parse_boolean(soup.useroptions.emailchallengewinner.text)
        self._email_route_boss = parse_boolean(soup.useroptions.emailrouteboss.text)
        self._run_data_granularity = int(soup.useroptions.rundatagranularity.text)
        
        self._most_recent_run_id = soup.mostrecentrun['id']
        self._start_time = parse_datetime(soup.mostrecentrun.starttime.text)
        self._distance = float(soup.mostrecentrun.distance.text)
        self._duration = int(soup.mostrecentrun.duration.text)
        self._workout_type = soup.mostrecentrun.workouttype.text
        self._equipment = soup.mostrecentrun.equipment.text

    @property
    def active_owned_callenge_count(self):
        return self._active_owned_callenge_count
    @property
    def avatar(self):
        return self._avatar
    @property
    def average_runs_per_week(self):
        return self._average_runs_per_week
    @property
    def average_step_count(self):
        return self._average_step_count
    @property
    def calories_pedometer(self):
        return self._calories_pedometer
    @property
    def city(self):
        return self._city
    @property
    def country(self):
        return self._country
    @property
    def date_format(self):
        return self._date_format
    @property
    def distance(self):
        return self._distance
    @property
    def distance_unit(self):
        return self._distance_unit
    @property
    def duration(self):
        return self._duration
    @property
    def email(self):
        return self._email
    @property
    def email_challenge_ending(self):
        return self._email_challenge_ending
    @property
    def email_challenge_starting(self):
        return self._email_challenge_starting
    @property
    def email_challenge_winner(self):
        return self._email_challenge_winner
    @property
    def email_goal_complete(self):
        return self._email_goal_complete
    @property
    def email_goal_ending(self):
        return self._email_goal_ending
    @property
    def email_route_boss(self):
        return self._email_route_boss
    @property
    def email_weekly_training(self):
        return self._email_weekly_training
    @property
    def equipment(self):
        return self._equipment
    @property
    def external_profile_id(self):
        return self._external_profile_id
    @property
    def gender(self):
        return self._gender
    @property
    def id(self):
        return self._id
    @property
    def is_public(self):
        return self._is_public
    @property
    def last_calculated(self):
        return self._last_calculated
    @property
    def longest_step_count(self):
        return self._longest_step_count
    @property
    def most_recent_run_id(self):
        return self._most_recent_run_id
    @property
    def pedo_workouts(self):
        return self._pedo_workouts
    @property
    def plusLevel(self):
        return self._plusLevel
    @property
    def preferred_run_day_of_week(self):
        return self._preferred_run_day_of_week
    @property
    def previous_sync_time(self):
        return self._previous_sync_time
    @property
    def run_data_granularity(self):
        return self._run_data_granularity
    @property
    def screen_name(self):
        return self._screen_name
    @property
    def start_time(self):
        return self._start_time
    @property
    def start_week(self):
        return self._start_week
    @property
    def state(self):
        return self._state
    @property
    def total_calories(self):
        return self._total_calories
    @property
    def total_calories_pedometer(self):
        return self._total_calories_pedometer
    @property
    def total_cardio_distance(self):
        return self._total_cardio_distance
    @property
    def total_distance(self):
        return self._total_distance
    @property
    def total_duration(self):
        return self._total_duration
    @property
    def total_heart_rate_only_activities(self):
        return self._total_heart_rate_only_activities
    @property
    def total_runs_runs(self):
        return self._total_runs_runs
    @property
    def total_runs_with_heartrate(self):
        return self._total_runs_with_heartrate
    @property
    def total_runs_with_routes(self):
        return self._total_runs_with_routes
    @property
    def total_steps(self):
        return self._total_steps
    @property
    def total_workouts(self):
        return self._total_workouts
    @property
    def uploaded_avatar(self):
        return self._uploaded_avatar
    @property
    def workout_type(self):
        return self._workout_type
