# -*- coding: utf-8 -*-
from parser import *

class Snapshot:
    def __init__(self, soup):
        self._event = soup['event']
        self._id = soup['id']
        self._pace = int(soup.pace.text)
        self._distance = float(soup.distance.text)
        self._duration = int(soup.duration.text)

    @property
    def event(self):
        return self._event
    
    @property
    def id(self):
        return self._id
    @property
    def pace(self):
        return self._pace
    @property
    def distance(self):
        return self._distance
    @property
    def duration(self):
        return self._duration
                
class SingleRun:
    def __init__(self, soup):
        self._snap_shots = []
        for c1 in soup.findAll('snapshot'):
            ss = Snapshot(c1)
            self._snap_shots.append(ss)
            
        self._start_time = soup.sportsdata.starttime.text
        self._weight = float(soup.sportsdata.userinfo.weight.text)
        self._device = soup.sportsdata.userinfo.device.text
        self._wordkout_type = soup.runsummary['workouttype']
        self._distance = float(soup.sportsdata.runsummary.distance.text)
        self._duration = int(soup.sportsdata.runsummary.duration.text)
        self._calories = float(soup.sportsdata.runsummary.calories.text)
        self._equipment_type = soup.sportsdata.runsummary.equipmenttype.text
        
        self._description = parse_soup_by_tagname(soup, 'description')
        self._is_humanrace_run = parse_soup_by_tagname(soup, 'ishumanracerun')
        self._is_firstheart_run = parse_soup_by_tagname(soup, 'isfirstheartrun')
        self._how_felt = parse_soup_by_tagname(soup, 'howfelt')
        self._weather = parse_soup_by_tagname(soup, 'weather')
        self._intensity = parse_soup_by_tagname(soup, 'intensity')
        self._terrain = parse_soup_by_tagname(soup, 'terrain')

    @property
    def start_time(self):
        return self._start_time

    @property
    def weight(self):
        return self._weight

    @property
    def device(self):
        return self._device

    @property
    def wordkout_type(self):
        return self._wordkout_type

    @property
    def distance(self):
        return self._distance
    
    @property
    def duration(self):
        return self._duration
    
    @property
    def calories(self):
        return self._calories

    @property
    def equipment_type(self):
        return self._equipment_type

    @property
    def description(self):
        return self._description

    @property
    def how_felt(self):
        return self._how_felt

    @property
    def weather(self):
        return self._weather

    @property
    def terrain(self):
        return self._terrain

    @property
    def is_humanrace_run(self):
        return self._is_humanrace_run
    
    @property
    def is_firstheart_run(self):
        return self._is_firstheart_run

    @property
    def intensity(self):
        return self._intensity




    
