# -*- coding: utf-8 -*-
class Run:
    def __init__(self, soup):
        self._id = soup['id']
        self._workout_type = soup['workouttype']
        self._distance = float(soup.distance.text)
        self._duration = int(soup.duration.text)
        self._minutes = self._duration / 60000
        self._seconds = self._duration % 60000 / 1000
        self._km = "%.2f" % self._distance

    @property
    def id(self):
        return self._id

    @property
    def workout_type(self):
        return self._workout_type

    @property
    def distance(self):
        return self._distance

    @property
    def duration(self):
        return self._duration

    @property
    def minutes(self):
        return self._minutes

    @property
    def seconds(self):
        return self._seconds

    @property
    def km(self):
        return self._km
