
"""
This is the nester.py module, and it provides one function called
list_printer() which prints lists that may or may not include nester lists
"""
def list_printer(the_list, level):
	"""
	This function takes a positional argument called "the_list", which is any
	Python list (of, possibly nested list). Each data item in the provided list
	is (recursively) printed to the screen on its own line.
	A second argument called "level" is used to insert -tab-stops when a nested
	list is encountered.
	"""
	for item in the_list:
		if isinstance(item, list):
			list_printer(item, level + 1)
		else:
			for tab_stop in range(level):
				print("\t", end='')
			print(item)
