""" Switch member data objects to non-archetype dependent light weight objects """
from betahaus.openmember import CATALOG_ID, DATABASE_ID
from betahaus.openmember.interfaces import IOMDataHandler
from Products.CMFCore.utils import getToolByName
from betahaus.openmember import logger

def migrate(context):
    """ Migrate to 0.1b3 """
    portal = getToolByName(context, 'portal_url').getPortalObject()
    member_data_upgrade_step(portal)


def member_data_upgrade_step(portal):
    if getToolByName(portal, DATABASE_ID, None) == None:
        logger.info("Nothing to do for upgrade step since database don't exist.")
    else:
        om_catalog = getToolByName(portal, CATALOG_ID)
        om_database = IOMDataHandler(om_catalog).database
        for key in om_database.keys():
            data = om_database.get(key)
            if data.member_id == None:
                data.member_id = key
                om_catalog.indexObject(data)