from betahaus.openmember.tests.base import TestCase
import unittest
from Products.PloneTestCase import PloneTestCase as ptc
from Products.CMFCore.utils import getToolByName
from Products.PluginIndexes.KeywordIndex.KeywordIndex import KeywordIndex
from Products.ZCTextIndex.ZCTextIndex import ZCTextIndex
from Products.Archetypes.utils import shasattr


ptc.setupPloneSite()

class TestCatalog(TestCase):
    """ """
    def afterSetUp(self):
        """ """
        self.om_catalog = getToolByName(self.portal , 'openmember_catalog')
        self.membership = getToolByName(self.portal, 'portal_membership')

        self.membership.addMember('portal_member', 'pm', ['Member'], [], {})
        self.membership.addMember('manager', 'test_manager', ['Manager'], [], {})
        self.membership.addMember('editor', 'test_editor', ['Editor'], [], {})

        portal_setup = getToolByName(self.portal , 'portal_setup')
        
        # we need this one in order to have some content to create in the portal.
        portal_setup.runAllImportStepsFromProfile('profile-betahaus.openmember:betahaus.openmember-personcontent', purge_old=False)
        
    
    def test_adding_index(self):
        
        self.failIf('test_index' in self.om_catalog.indexes())
        self.om_catalog.addIndex('test_index', 'KeywordIndex')
        self.failUnless('test_index' in self.om_catalog.indexes())
        index = self.om_catalog.Indexes.get('test_index')
        self.assertEquals(index.__class__, KeywordIndex)
        self.assertEquals(index.id, 'test_index')
        self.assertEquals(index.label, 'test_index')
        
        # there should always be a sortable index to accompany, that is a KeywordIndex
        sortable_index = self.om_catalog.Indexes.get('sortable_test_index')
        self.assertEquals(sortable_index.__class__, KeywordIndex)
        self.assertEquals(sortable_index.id, 'sortable_test_index')
        self.failIf(shasattr(sortable_index, 'label'))

    def test_del_index(self):
        
        self.failIf('test_index' in self.om_catalog.indexes())
        self.om_catalog.addIndex('test_index', 'KeywordIndex')
        self.failUnless('test_index' in self.om_catalog.indexes())
        
        self.om_catalog.delIndex('test_index')
        self.failIf('test_index' in self.om_catalog.indexes())
        self.failIf(self.om_catalog.Indexes.get('sortable_test_index'))
        
    def test_adding_index_with_label(self):
        
        self.om_catalog.addIndex('test_index2', 'ZCTextIndex', label = 'Test')
        index = self.om_catalog.Indexes.get('test_index2')
        self.assertEquals(index.__class__, ZCTextIndex)
        self.assertEquals(index.id, 'test_index2')
        self.assertEquals(index.label, 'Test')
        
        sortable_index = self.om_catalog.Indexes.get('sortable_test_index2')
        self.assertEquals(sortable_index.__class__, KeywordIndex)
        self.assertEquals(sortable_index.id, 'sortable_test_index2')
        self.failIf(shasattr(sortable_index, 'label'))
        
    def test_add_internal_index(self):
        """Internal indexes should not be part of the mirrorableIndexes."""
        self.om_catalog.addIndex('test', 'FieldIndex', internal = True)
        self.failUnless('test' in self.om_catalog.allindexes())
        self.failIf('test' in self.om_catalog.mirrorableIndexes())
        
    def test_del_internal_index(self):
        """Internal indexes should not be part of the mirrorableIndexes."""
        self.om_catalog.addIndex('test', 'FieldIndex', internal = True)
        self.failUnless('test' in self.om_catalog.allindexes())
        self.om_catalog.delIndex('test')
        self.failIf('test' in self.om_catalog.allindexes())

        
def test_suite():
    """ """
    suite = unittest.TestSuite()
    suite.addTest(unittest.makeSuite(TestCatalog))
    return suite
