from Products.Five import zcml
from Products.Five import fiveconfigure

from Testing import ZopeTestCase as ztc

from Acquisition import Explicit

from Products.CMFPlone.tests import PloneTestCase as ptc
from Products.PloneTestCase.layer import onsetup

@onsetup
def setup_product():
    """Set up additional products and ZCML required to test this product.

    The @onsetup decorator causes the execution of this body to be deferred
    until the setup of the Plone site testing layer.
    """

    # Load the ZCML configuration for this package and its dependencies

    fiveconfigure.debug_mode = True
    import betahaus.openmember
    zcml.load_config('configure.zcml', betahaus.openmember)
    fiveconfigure.debug_mode = False

    # We need to tell the testing framework that these products
    # should be available. This can't happen until after we have loaded
    # the ZCML.

    ztc.installPackage('betahaus.openmember')

# The order here is important: We first call the deferred function and then
# let PloneTestCase install it during Plone site setup

setup_product()
ptc.setupPloneSite(products=['betahaus.openmember'])

class TestCase(ptc.PloneTestCase):
    """Base class used for test cases
    """

class FunctionalTestCase(ptc.FunctionalTestCase):
    """Test case class used for functional (doc-)tests
    """
    def afterSetUp(self):
        self.setRoles(('Manager',))



class DummyContext(Explicit):

    def __init__(self):
        self.context = None



class DummyIndex(object):

    def __init__(self, id, label):
        self.title = label
        self.label = label
        self.id = id


class DummyCatalogTool(dict):

    def __init__(self):
        self['membership_references'] = DummyIndex('membership_references','Memberships')
        self['city'] = DummyIndex('city', 'City')

    def indexes(self):
        return self.keys()
    
    def Indexes(self):
        return self