from zope.interface import Interface
from zope.component.interfaces import IObjectEvent

from zope import schema

from betahaus.openmember import OpenMemberMessageFactory as _
from betahaus.openmember.browser.widget import IOMIndexPair

class IOpenMember(Interface):
    """ This defines a content type as a potential member.
        Any content type with this interface will fire up an event.
        You can add the interface through zcml:
        <five:implements
            class=".demomember.DemoMember" 
            interface="betahaus.openmember.interfaces.IOpenMember"/> 
    """
class IOpenMemberCatalog(Interface):
    """Custom catalog
    """

class IOpenMemberPortlet(Interface):
    """Interface for portlet"""

class IFiscalYear(Interface):
    """Folder that stores members for a specific fiscal year"""
    
class IMemberData(Interface):
    """Content type that stores member data"""

    member_id = schema.ASCIILine(
        title=_(u"Id"),
        required=True)

class IBaseMember(Interface):
    """Mixin class for content with minimum requirements met to be a member.
    """

class IBasePerson(Interface):
    """Mixin for a member content type that is actually a person.
    """

class IBaseOrganisation(Interface):
    """Mixin for members that are organisations or companies
    """

class IMemberPerson(Interface):
    """Actual content type that inherits from BasePerson"""

class IMemberOrganisation(Interface):
    """Actual content type that inherits from BasePerson"""

class IOMBaseView(Interface):
    """Base view for listings involving OpenMember data"""

class IFiscalYearView(Interface):
    """Marker interface for browser view"""

class IOMControlPanelForm(Interface):
    """Interface for forms that are to be part of the Control Panel"""
    
    def getId():
        """ the id"""
    
    def getLabel():
        """ the label """


            
class IOMControlPanelDatabaseSchema(IOMControlPanelForm):
    """Interface for the control panel schema"""

    fields_to_index = schema.List(
        title=_(u'Fields to index'),
        description=_(u"Store Member Data from these fields."),
        default=[],
        value_type=schema.Object(IOMIndexPair),
        required=False,
        )

    
    title_fields = schema.List(
        title=_(u'Title fields'),
        description=_(u"Add the fields that should be searchable, empty means all fields."),
        missing_value = set(),
        value_type=schema.Choice(vocabulary = 'betahaus.openmember.SelectableIndexes'),
        required=False,
        )    


class IOMDataHandler(Interface):
    """Interface that handles all communication with the OpenMember database
    """

    def addMember(obj):
        """obj is the member that needs to be mapped"""

    def updateMember(obj):
        """Updates member data for obj"""
    
    def removeDeletedMember(id):
        """ Deletes an object in the database if it has been marked as orphaned, otherwise raises an exception. """

class IOMemberAddedEvent(IObjectEvent):
    """A field has been modified, versioning needed"""

class IOMemberModifiedEvent(IObjectEvent):
    """A field has been modified, versioning needed"""

class IOMemberWillBeModifiedEvent(IObjectEvent):
    """A field has been modified, versioning needed"""

class IOMemberDeletedEvent(IObjectEvent):
    """A field has been modified, versioning needed"""
    
class IOpenMemberContextResults(Interface):
    """Adapter for getting results from different contenttypes.
    """
    
    def getResults():
        """Returns the results for this context.
        """
        

