
from zope.component.interfaces import ObjectEvent
from betahaus.openmember.interfaces import IOMemberAddedEvent,\
                                           IOMemberModifiedEvent,\
                                           IOMemberWillBeModifiedEvent,\
                                           IOMemberDeletedEvent
from zope.interface import implements
from zope.event import notify

class OMEvent(ObjectEvent):
    """A base class for openmember events"""

    def __init__(self, om_object, contenttypeobject) :
        """
        Init with database object and contenttype object.
        databseobject => the object found in the openmember database
        contenttype object => the object mirrored

        >>> from zope.interface import Interface, implements
        >>> class Sample(object):
        ...     implements(Interface)



        """
        super(OMEvent, self).__init__(contenttypeobject)
        self.om_object = om_object


class OMemberAddedEvent(OMEvent):
    """A member has been added"""

    implements(IOMemberAddedEvent)

class OMemberModifiedEvent(OMEvent):
    """A member has been added"""

    implements(IOMemberModifiedEvent)

class OMemberWillBeModifiedEvent(OMEvent):
    """A member has been added"""

    implements(IOMemberWillBeModifiedEvent)
    
class OMemberDeletedEvent(OMEvent):
    """A member has been added"""

    implements(IOMemberDeletedEvent)
