from Globals import InitializeClass

from zope.interface import implements

from AccessControl import ClassSecurityInfo

#from Products.CMFCore.utils import getToolByName
from Products.CMFCore.permissions import View, ModifyPortalContent, ReviewPortalContent

from Products.Archetypes import atapi

from Products.ATContentTypes.content.base import ATCTContent
from Products.ATContentTypes.content import schemata
from Products.ATReferenceBrowserWidget.ATReferenceBrowserWidget import ReferenceBrowserWidget

from betahaus.openmember import PROJECTNAME, OPENMEMBER_SEARCH_DATABASE
from betahaus.openmember import OpenMemberMessageFactory as _
from betahaus.openmember.interfaces import IOpenMember, IBaseMember, IBasePerson, IBaseOrganisation


BaseMemberSchema = atapi.Schema((
    atapi.ReferenceField(
        name='membership_references',
        multiValued=True,
        read_permission = OPENMEMBER_SEARCH_DATABASE,
        relationship='membership_references_targets',
        widget=ReferenceBrowserWidget(
            label = _(u"Memberships"),
        ),
    ),  
))


BaseAddressSchema = atapi.Schema((
    atapi.StringField(name='street_address',
                      searchable=True,
                      widget = atapi.StringWidget(label = _('Street adress'),
                            ),
                      ),
    atapi.StringField(name='street_address2',
                      searchable=True,
                      widget = atapi.StringWidget(label = _('Extra adress'),
                            ),
                      ),
    atapi.StringField(name='postal_code',
                      searchable=True,
                      widget = atapi.StringWidget(label = _('Postal code'),
                            ),
                      ),
    atapi.StringField(name='postal_area',
                      searchable=True,
                      widget = atapi.StringWidget(label = _('Postal Area'),
                            ),
                      ),
    atapi.StringField(name='state_province',
                      searchable=True,
                      widget = atapi.StringWidget(label = _('State / Province'),
                            ),
                      ),
    atapi.StringField(name='country',
                      searchable=True,
                      widget = atapi.StringWidget(label = _('Country'),
                            ),
                      ),
))


BasePersonSchema = schemata.ATContentTypeSchema.copy() + atapi.Schema((

    atapi.StringField(name='first_name',
                      searchable=True,
                      widget = atapi.StringWidget(label = _('First name'),
                            ),
                      ),
    
    atapi.StringField(name='last_name',
                      searchable=True,
                      widget = atapi.StringWidget(label = _('Last name'),
                            ),
                      ),
    
    atapi.DateTimeField(name='date_of_birth',
                        widget=atapi.CalendarWidget(label=_(u'Date of birth'),
                                              show_hm = False,
                                              starting_year=1900,
                                              ),
                        ),
)) + BaseMemberSchema.copy() + BaseAddressSchema.copy()


BaseOrganisationSchema = schemata.ATContentTypeSchema.copy() + atapi.Schema((
    #FIXME: Add org schema
)) + BaseMemberSchema.copy() + BaseAddressSchema.copy()

class BaseMember(ATCTContent):
    """Base mixin for things that can be members. This is contains all the minimal requirements."""
    schema = BaseMemberSchema
    security = ClassSecurityInfo()
    implements(IBaseMember,IOpenMember)
    
    #Set this for properties that shouldn't have history
    disable_history = []
    
    #FIXME: We'll want to tighten up security here
    security.declareProtected(View, 'membership_references')
    def membership_references(self):
        return self.getRawMembership_references()

InitializeClass(BaseMember)


class BasePerson(BaseMember):
    """Mixin for members who're actual people"""
    schema = BasePersonSchema
    implements(IBasePerson)

InitializeClass(BasePerson)

class BaseOrganisation(BaseMember):
    """Mixin for members that are organisations"""
    schema = BaseOrganisationSchema
    implements(IBaseOrganisation)

InitializeClass(BaseOrganisation)