from zope.schema.fieldproperty import FieldProperty
from zope.interface import implements

from persistent import Persistent
from OFS.Traversable import Traversable
from Acquisition import Implicit
from Acquisition import aq_base

from Products.CMFCore.utils import getToolByName

from betahaus.openmember.interfaces import IMemberData
from betahaus.openmember import CATALOG_ID
from DateTime.DateTime import DateTime
from Products.Archetypes.utils import shasattr
from plone.memoize.instance import memoize


class MemberData(Persistent, Traversable, Implicit):
    """A lightweight contenttype that is indexable by a catalog.
    """
    implements(IMemberData)
    meta_type = 'MemberData'
    member_id = FieldProperty(IMemberData['member_id'])
    
    def __init__(self, id):
        if type(id) != str or not id:
            raise TypeError("Tried to create MemberData with a non-valid id. Content was: %s" % id)
        self.member_id = id
        
    def __getitem__(self, value):
        """
            Returns the attribute with name 'value' if attribute don't exist returns None
        """
        return getattr(aq_base(self), value)
        
    def __setitem__(self, attribute, value):
        """
            Sets the attribute to value, saves the change in a history.
            
            The history is stored in a attribute called _<attribute name>_history. So the
            history for attribute ``firstname`` would be called ``_firstname_history``
            
            The history is a list of dictionaries where each entry looks like::

               {'data':value,
                'modified':self.modified,
                'user':userid,
                }
                
                 
        """

        # There was a change so update the modified date to now.
        self.modified = DateTime()

        # Compute the name of the history attribute 
        attribute_history = '_%s_history' % attribute
        
        #Get current users ID
        userid = self.membership().getAuthenticatedMember().getId()
        
        #Create history attribute if it doesn't exist
        if not shasattr(self, attribute_history):
            setattr(self, attribute_history, [])
            
        #Write current change to history
        history_obj = getattr(self, attribute_history)
        history_obj.append({'data':value,
                            'modified':self.modified,
                            'user':userid,
                            })
        
        #Set main value
        setattr(self, attribute, value)

    @memoize
    def membership(self):
        return getToolByName(self, 'portal_membership', None)
    
    @property
    def id(self):
        return self.member_id and str(self.member_id) or None
        
    def getId(self):
        return self.id
        
    def _getMappedObject(self):
        """ Returns the object that this MemberData is mapped from.
            The id of this object is the same as the uid of the object mapped."""
        return getToolByName(self, 'reference_catalog').lookupObject(self.id)

    def getMappedObjectUID(self):
        mapped = self._getMappedObject()
        if mapped:
            return str(mapped.UID())
        return 'orphaned'

    def omcIndexObject(self):
        getToolByName(self, CATALOG_ID).indexObject(self)

    def omcReIndexObject(self):
        getToolByName(self, CATALOG_ID).reindexObject(self)
        
    def omcUnIndexObject(self):
        getToolByName(self, CATALOG_ID).unindexObject(self)


