
from zope import schema
from zope.interface import Interface, implements

from betahaus.openmember import OpenMemberMessageFactory as _

class IOMIndexPair(Interface):
    name = schema.TextLine(title=_(u"Name"))
    meta_type = schema.Choice(title=_(u"Type"),
                              vocabulary = u'betahaus.openmember.SelectableMetaTypes')
    label = schema.TextLine(title=_(u"Label"))

class OMIndexPair:
    implements(IOMIndexPair)
    def __init__(self, name='', meta_type='', label=''):
        self.name = name
        self.meta_type = meta_type
        self.label = label
        
    def __eq__(self, other):
        if IOMIndexPair.providedBy(other):
            if self.name == other.name and\
               self.meta_type == other.meta_type and\
               self.label == other.label:
                return True
