from DateTime import DateTime
from ZTUtils import make_query

import re

from betahaus.openmember.browser import baseview
from Products.CMFCore.utils import getToolByName


class OMSearch(baseview.OMBaseView):
    """The search result view"""

    def _parseDate(self, date):
        """Parses a string for dates and date ranges. Possible dates and ranges are:
                
        from 1980-05-10
        this gives a range from beginning of time up until the specified date
        
        to 1980-05-10
        this gives a range from specified date to end of time
        
        1980-05-10 to 2000-01-01
        this gives a range between the two dates
        
        """
        
        if not isinstance(date, str) or len(date) <= 0:
            # No string, no go. or no length no go
            return {}
        
        query = {}
        for part in date.split(' '):
            if part == 'from':
                if not query.has_key('query'):
                    query['range'] = 'min'
                    
            elif part == 'to':
                if not query.has_key('query'):
                    query['range'] = 'max'
            
            elif re.match('^\d{4}\-\d{1,2}$', part):
                part = part.replace('-','/')
                part = part + '/01'

                
                if query.has_key('query'):
                    date1 = query['query'][0]
                else:   
                    date1 = DateTime(part)
                
                date2 = DateTime(part) + 28
                for i in range(5):
                    # 5 is enough to flip over to next month even for February. 
                    date2 = date2 + 1
                    if date2.day() >= 1:
                        date2 = date2 - 1
                        date2 = date2.latestTime()
                        break
                
                query['query'] = (date1,date2)
                
            elif re.match('^\d{4}\-\d{1,2}\-\d{1,2}$', part):
                # The '-' needs to be replaced by '/' because of some wierd behaviour in DateTime
                part = part.replace('-','/')
                if query.has_key('query'):
                    date1 = query['query'][0]
                else:   
                    date1 = DateTime(part)
                date2 = DateTime(part).latestTime()
                query['query'] = (date1,date2)
        

        if query.has_key('query') and not query.has_key('range'):
            query['range'] = 'min:max'
                    
        return query
                
        
    def getResults(self):
        """Looks in the request for all possible indexes and builds a query.
        The query is then passed on to the openmember_catalog to get the search results.
        If a index of the type DateIndex has a value it is parsed for date ranges by _parseDate.
        """
        query = self.get_sorting_options()
        not_query = {}
        
        for index in self.openmember_catalog.mirrorableIndexes():
            # the extra get is for the handling the padding done in the search portlet.
            not_value = self.request.get('not-omportlet-'+index, False)
            value = self.request.get(index, self.request.get('omportlet-'+index, ''))

            if value != '':
                if self.openmember_catalog.Indexes.get(index).meta_type == 'DateIndex':
                    date_query = self._parseDate(value)
                    if date_query.has_key('query') and date_query.has_key('range'):
                        #Date range queries aren't supported yet!
                        query[index] = date_query
                else:
                    if not_value:
                        not_query[index] = value
                    else:
                        query[index] = value

        if not_query:
            #To speed up execution, we already know that posts not meeting the other criteria won't be selected
            not_query.update(query)
            #All ids are unique in the openmember database, so remove them from the final query.
            #We can't match on the brain objects themselves - they seem to be runtime created.
            not_results = set([x.id for x in self.openmember_catalog(not_query)])
            return [x for x in self.openmember_catalog(query) if x.id not in not_results]
        else:
            #We need to abort if it doesn't have any results
            if not query:
                return []
            return self.openmember_catalog(query)
        
    def make_form_get_query(self):
        """ Construct a get-url from the current search. """
        return "?%s" % make_query(self.request.form)
