from Acquisition import aq_parent
from plone.memoize.forever import memoize as memoize_forever
from Products.CMFCore.utils import getToolByName
from Products.CMFCore.permissions import DeleteObjects
from zExceptions import Forbidden
from Products.statusmessages.interfaces import IStatusMessage
from betahaus.openmember.browser.search import OMSearch
from betahaus.openmember import OpenMemberMessageFactory as _


class DeleteForm(OMSearch):
    """ Delete form """
    
    def __call__(self):
        
        #Form submitted?
        if getattr(self.request, 'submitted', None):
            #Only allow post
            if self.request.REQUEST_METHOD != 'POST':
                raise Forbidden("Get method not allowed")
            #Make sure the person who deletes actually checked the delete checkbox
            if not getattr(self.request, 'confirm_delete', None):
                IStatusMessage(self.request).addStatusMessage(_(u"Confirm delete not checked - aborting"), 'error')
                url = getattr(self.request, 'came_from', False) or getToolByName(self.context, 'portal_url')()
                return self.request.response.redirect(url)
                
            #Everything okay - let's nuke 'em!
            uids = self.request.delete_uids
            lookupObject = self.reference_catalog.lookupObject
            i=0
            for uid in uids:
                obj = lookupObject(uid)
                if not obj:
                    continue
                parent = aq_parent(obj)
                parent._delObject(obj.getId())
                i+=1
            
            #Delete done
            if i == len(uids):
                IStatusMessage(self.request).addStatusMessage(_(u"All %s object(s) deleted" % i), 'info')
            else:
                text = _(u"%s of %s object(s) deleted. They may not have been found or already deleted." % (i, len(uids)))
                IStatusMessage(self.request).addStatusMessage(text, 'info')
            return self.request.response.redirect(getToolByName(self.context, 'portal_url')())
        
        #This is run if the form isn't submitted
        return super(DeleteForm, self).__call__()

    
    @property
    @memoize_forever
    def checkPermission(self):
        pm = getToolByName(self.context,'portal_membership')
        return pm.checkPermission
    
    def getObjectsToDelete(self):
        results = set()
        lookupObject = self.reference_catalog.lookupObject
        
        for brain in self.getResults():
            results.add(lookupObject(brain.getMappedObjectUID))
        return results
    
    def check_delete_perm(self, obj):
        """ Check if the user has delete permission on the objects parent.
            (That's where the permission is needed.
        """
        parent = aq_parent(obj)
        return self.checkPermission(DeleteObjects,parent)