from urllib import quote_plus
from Products.Five.browser import BrowserView

from Products.CMFPlone.interfaces import IPloneSiteRoot

from Products.CMFCore.utils import getToolByName

from plone.memoize.instance import memoize

from zope.interface import implements

from ZTUtils import make_query

from betahaus.openmember.interfaces import IOMBaseView
from zope.deprecation import deprecate

    
class OMBaseView(BrowserView):
    """ Base view for OpenMember listings
    """
    
    implements(IOMBaseView)
    
    referenced_objects = {}
    
    @property
    @memoize
    def openmember_catalog(self):
        return getToolByName(self.context, 'openmember_catalog')
    
    @property
    @memoize
    def omindexes(self):
        return self.openmember_catalog.mirrorableIndexes()
    
    @property
    @memoize
    def omsort_indexes(self):
        return self.openmember_catalog.sortindexes()
    
    @property
    @memoize
    def reference_catalog(self):
        return getToolByName(self.context, 'reference_catalog')
    
    @property
    @memoize
    def portal_catalog(self):
        return getToolByName(self.context, 'portal_catalog')
    

    def get_reference(self, uid):
        if uid not in self.referenced_objects.keys():
            obj = self.reference_catalog.lookupObject(uid)
            if obj:
                self.referenced_objects[uid] = obj
        return self.referenced_objects.get(uid,None)
           
    def getAddressFields(self):
        portal_properties = getToolByName(self.context, 'portal_properties', None)
        openmember_properties = getattr(portal_properties, 'openmember_properties', None)
        if openmember_properties.hasProperty('address_fields'):
            return list(openmember_properties.getProperty('address_fields'))
        else:
            return []

    def getFields(self):
        """Returns the fields that are to be shown, Now taken from the 'address_fields' property 
        on the 'openmember_properties' if available. Otherwise all indexes are returned.
        """
        fields = []
        
        portal_properties = getToolByName(self.context, 'portal_properties', None)
        openmember_properties = getattr(portal_properties, 'openmember_properties', None)
        if openmember_properties.hasProperty('title_fields'):
            fields = list(openmember_properties.getProperty('title_fields'))
        
        # This is if no indexes are chosen, all indexes are shown.
        # getProperty returns ('',) which needs more checks to find.  
        if len(fields) == 0 or len(fields) == 1 and fields[0] == '':
            fields = self.omindexes
                
        result = []

        #Sort according to field order in portal_properties
        for field in fields:
            index = self.openmember_catalog.Indexes.get(field)
            #Empty indexes will have len of 0 and be considered false!
            if index is not None:
                result.append( {'id':index.id,
                                'type':index.meta_type,
                                'title':getattr(index,'label',index.id)})
        return result

    def getFormatedField(self,item,field):
        """Hook to format specific fields. Right now used for DateIndex and lists of UIDs"""
        
        #Fetch data
        data = getattr(item, field['id'])

        #Make dates cute
        if field['type'] == 'DateIndex':
            return self.context.toLocalizedTime(data, long_format=0)
        #Fetch sub-items of membership_references or other lists and return as a list
        if type(data) == list:
            return [self.get_reference(uid) for uid in data]
        
        #Just return data
        return data

    def showGeoLinks(self):
        """Check if context has enough metadata to make a query to google maps"""
        fields_to_check = self.getAddressFields()
        # this '&' is the intersection between two sets, i.e results in any element that are both lists.
        if set(fields_to_check) & set(self.omindexes):
            return True
        return False
    
    def getGeoQuery(self, item):
        """ Construct a query for google maps lookup through a link
        """
        #Don't lookup if to few parameters are provided
        locationkeys = self.getAddressFields()

        query = ''
        for key in locationkeys:
            field = getattr(item, key, None)
            if field:
                query += "%s+" % quote_plus(field)
        #FIXME: Add a usable label
        #if 'label' in xxx:
        #    query += "(%s)" % label
        return query
    
    def getContentUrl(self, uid):
        """Returns the url to the content with uid
        """
        if not uid:
            return ''
        split = uid.rfind('/')
        if split:
            uid = uid[split+1:]
            
        result = self.portal_catalog(UID=uid)
        if len(result) == 1:
            return result[0].getURL()

    def current_sort_state(self, item=None):
        """Check which state the current item is in. Returns '', 'dec'or 'asc'
        """
        getvars = self.request.form.copy()
        sort_on = getvars.get('sort_on','')
        if sort_on == item:
            if getvars.get('sort_order','dec') == 'dec':
                return 'dec'
            else:
                return 'asc'
        
        #Special case: initial visit to the page
        if not sort_on and getvars.get('sort_order','dec') == 'dec' and item == 'sortable_name':
            return 'dec'
            
        #Not sorting on this column
        return ''
        
    def get_url(self, item=None):
        """ Return a url that includes current GET-values and and possible toggles for sorting.
            item is the item that the user can click on. (I.e. 'firstname')
        """
        url = self.context.absolute_url()
        if IPloneSiteRoot.providedBy(self.context):
            url += '/@@openmember_search'
        #FIXME: We might want to add the template to the urL: template_id template_id|template/getId;
        getvars = self.request.form.copy()
        
        #Invert sort order, default is dec
        sort_on = getvars.get('sort_on','')
        
        sort = self.current_sort_state(item)
        if sort == ('dec' or ''):
            getvars['sort_order'] = 'asc'
        else:
            getvars['sort_order'] = 'dec'

        #Now sorting on current item
        getvars['sort_on'] = item

        return "%s?%s" % (url, make_query(self.request.form,getvars) )
    
    def get_sorting_options(self):
        """This one looks in the request and returns sort_on and sort_order that is suitable for the catalog. 
        """
        query = {}
        sort_on = self.request.get('sort_on', None)
        if isinstance(sort_on, str) and ('sortable_%s' % sort_on) in self.omsort_indexes:
            query['sort_on'] = ('sortable_%s' % sort_on)
        
            sort_order = self.request.get('sort_order', None)
            if sort_order == 'asc':
                query['sort_order'] = 'reverse'
        return query
    
    def get_arguments(self, args):
        """This is to keep Plone 3 and Plone 4 compatibility.
        """
        for i in xrange(len(args)):
            if type(args[i]) == type({}):
                return args[i]
    