from zope.interface import implements
from zope.component import adapts
from betahaus.openmember.interfaces import IOpenMemberContextResults,\
    IMemberData
from betahaus.openmember.interfaces import IFiscalYear
from Products.CMFPlone.interfaces import IPloneSiteRoot
from plone.indexer.decorator import indexer


@indexer(IMemberData)
def getMappedObjectType(object):
    """Return the mapped objects type"""
    mapped = object._getMappedObject()
    if mapped:
        return [mapped.portal_type]
    else:
        return ['orphaned']


class BaseContextResults(object):
    implements(IOpenMemberContextResults)
    
    def __init__(self, context):
        self.context = context

class FiscalYearResults(BaseContextResults):
    """Handles export from fiscalyears
    """
    adapts(IFiscalYear)

        
    def getResults(self):
        """Interface implementation"""
        view = self.context.restrictedTraverse('view')
        return view.getOpenMembers()

class SearchResults(BaseContextResults):
    """Handles export from searches
    """
    adapts(IPloneSiteRoot)

        
    def getResults(self):
        """Interface implementation"""
        view = self.context.restrictedTraverse('openmember_search')
        return view.getResults()

