##*DxfStructure Concrete help*

---
###*Available functions*

|Name|Description|
|-------|----------|
|`(1)Concrete Check`| Checks the drawing|
|`(2)Concrete Check and save`| Checks the drawing and draws warnings in modelspace on `DS_TMPCHECK` layer|
|`(3)Concrete Show dependencies and save`| Shows bar annotation dependencies and draws them as line in modelspace on `DS_TMPCHECK` layer
|`(4)Concrete Process data and save`| Updates quantities and marks of bars|
|`(5)Concrete Process data with renumerate and save`| Updates quantities and marks of bars and renumerates bars|
|`(6)Concrete Process data with renumerate, schedules and save`| Updates quantities and marks of bars and renumerates bars then draws bar schedule in modelspace|
|`(7)Concrete Help`| Displays help for concrete|
---
###*Layer system used for concrete drawing *

|Name|Description|
|-------|----------|
|`DS_CBAR`|Bar shape pline definition|
|`DS_CTEXT`| Bar annotation|
|`DS_DEPLINE`|Definition of annotation dependency|
|`DS_ELEMENT`|Definition of element area in model space|
|`DS_RANGE`|Bar arrangement definition|
|`DS_SCHEDULE`|Used to create bar schedule|
|`DS_TMPCHECK`|Temporary layer for warning|

---
###*Bar annotation syntax*

|`5`|`#`|`12`|-|[|`10`|]|-|`200`|`T`|
|-|-|-|-|-|-|-|-|-|-|
|Number|Type|Size|-|[|Mark|]|-|Centre|Location|

|Legend:| |
|-------|----------|
|Number|- number of bars (1,2,4,5..)|
|Type|- steel type symbol (# - B500A)|
|Size|- standard bar diameter in [mm] (6,8,12,14,16 ...)|
|Mark|- bar mark (auto generated by program)|
|Centre|- bar space inside arrangement in [mm] (100, 200, 250 ...) |
|Location|- bar location symbol (T-top, B-bottom, TB - top and bottom etc.)|

|Example:|(total number)|
|---|---|---|
|15#10-[3]-200ZW|(30)|
|15#10-[3]-200Z|(15)|
|15#10-[3]-200|(15)|
|15#10-[3]|(15)|
|15#10-[3]-Z|(15)|
|15#10-[3]-ZW|(30)|
|#10-[3]|(0)|
|1#10-[3]|(1)|
|[3]|(0)|
|etc.|sd|
---
###*Bar annotation special colours*
|Color|meaning|
|-------|----------|
|`5` (blue)|- it does not stick to the bar peline, countable|
|`7` (white)|- it does not stick to the bar peline, uncountable|
|any other|- full active|

Use color `5` and `7` to create depended bar annotation.

---
###*Bar pline (on layer `DS_CBAR`) special colours*
|Color| |
|-------|----------|
|55|- dead bar pline|
|any other|- full active bar pline|

Use colour `55` to draw inactive bar illustration in drawing.

---
###*Element description syntax*

|`Element`|`_`|`Wall`|`_`|`x`|`_`|`5`|
|-|-|-|-|-|-|-|-|-|-|
|||Element name||||Number|

|Example:||
|---||
|Element Bk-1 x 5||
|Element Slup x 5||

---
##*Use case*
---
##*(1) - annotated bar*
![](help_concrete_usecase_1.png)
---
##*(2) - annotated bar with ref pline*
![](help_concrete_usecase_2.png)
---
##*(3) - annotated bar with dependence annotations*
![](help_concrete_usecase_3.png)
---
##*(4) - annotated bar with arrangement*
![](help_concrete_usecase_4.png)
---
##*(5) - element definition*
![](help_concrete_usecase_5.png)
---
##*(6)auto generated schedule for 1 - 5 use case in use_case.dxf*
![](help_concrete_usecase_schedule.png)

Please find `use_case.dxf` in `../dxfstructure/example` folder. There are a few example dxf files in the same folder too.