/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.modify;

import java.util.ArrayList;
import java.util.Collections;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.modify.DataOperation;

public class ConvertSeries
extends DataOperation {
    public static Dataset transform(Dataset base, String commands) {
        if (commands.isEmpty()) {
            return base;
        }
        String[] sections = ConvertSeries.parts(commands);
        String[] yFields = ConvertSeries.list(sections[0]);
        if (yFields == null || yFields.length < 2) {
            return base;
        }
        String[] otherFields = ConvertSeries.addRequired(ConvertSeries.list(sections[1]));
        int N = base.rowCount();
        Field series = ConvertSeries.makeSeries(yFields, N);
        Field values = ConvertSeries.makeValues(yFields, base, N);
        int[] indexing = ConvertSeries.makeIndexing(yFields.length, N);
        ArrayList<Field> resultFields = new ArrayList<Field>();
        resultFields.add(series);
        resultFields.add(values);
        for (String fieldName : otherFields) {
            if (fieldName.equals("#series") || fieldName.equals("#values")) continue;
            Field f = base.field(fieldName);
            resultFields.add(Data.permute(f, indexing, false));
        }
        Field[] fields = resultFields.toArray(new Field[resultFields.size()]);
        return base.replaceFields(fields);
    }

    private static String[] addRequired(String[] list) {
        ArrayList<String> result = new ArrayList<String>();
        Collections.addAll(result, list);
        if (!result.contains("#row")) {
            result.add("#row");
        }
        if (!result.contains("#count")) {
            result.add("#count");
        }
        return result.toArray(new String[result.size()]);
    }

    private static Field makeSeries(String[] names, int reps) {
        Field temp = Data.makeColumnField("#series", "Series", names);
        int[] blocks = new int[names.length * reps];
        for (int i = 0; i < names.length; ++i) {
            for (int j = 0; j < reps; ++j) {
                blocks[i * reps + j] = i;
            }
        }
        return Data.permute(temp, blocks, false);
    }

    private static Field makeValues(String[] yNames, Dataset base, int n) {
        Field[] y = new Field[yNames.length];
        for (int i = 0; i < y.length; ++i) {
            y[i] = base.field(yNames[i]);
        }
        Object[] data = new Object[y.length * n];
        for (int i = 0; i < y.length; ++i) {
            for (int j = 0; j < n; ++j) {
                data[i * n + j] = y[i].value(j);
            }
        }
        Field field = Data.makeColumnField("#values", Data.join(yNames), data);
        Data.copyBaseProperties(field, y[0]);
        return field;
    }

    private static int[] makeIndexing(int m, int reps) {
        int[] blocks = new int[m * reps];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < reps; ++j) {
                blocks[i * reps + j] = j;
            }
        }
        return blocks;
    }
}

