/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.brunel.data.Data;
import org.brunel.data.Field;

public class CSV {
    public static Field[] read(String base) {
        Object[][] data = CSV.parse(base);
        return CSV.makeFields(data);
    }

    public static String[][] parse(String data) {
        HashMap<String, String> common = new HashMap<String, String>();
        ArrayList lines = new ArrayList();
        ArrayList<String> line = new ArrayList<String>();
        char last = ' ';
        boolean inQuote = false;
        char separator = CSV.findSeparator(data);
        String building = null;
        int fieldCount = -1;
        for (int currentIndex = 0; currentIndex <= data.length(); ++currentIndex) {
            char c;
            char c2 = c = currentIndex == data.length() ? (char)'\n' : (char)data.charAt(currentIndex);
            if (inQuote) {
                if (c == '\"') {
                    if (currentIndex < data.length() - 1 && data.charAt(currentIndex + 1) == '\"') {
                        building = building + '\"';
                        ++currentIndex;
                    } else {
                        inQuote = false;
                    }
                } else {
                    building = building + c;
                }
            } else if (c == '\n' || c == '\r') {
                if (last != '\r' || c != '\n') {
                    if (line.isEmpty() && building == null) break;
                    line.add(CSV.saveMemory(building, common));
                    lines.add(line);
                    if (fieldCount < 0) {
                        fieldCount = line.size();
                    } else if (fieldCount != line.size()) {
                        throw new IllegalArgumentException("Line " + lines.size() + " had " + line.size() + " entries; expected " + fieldCount);
                    }
                    line = new ArrayList();
                    building = null;
                }
            } else if (c == '\"') {
                inQuote = true;
                if (building == null) {
                    building = "";
                }
            } else if (c == separator) {
                line.add(CSV.saveMemory(building, common));
                building = null;
            } else {
                if (building == null) {
                    building = "";
                }
                building = building + c;
            }
            last = c;
        }
        String[][] result = new String[lines.size()][];
        for (int i = 0; i < result.length; ++i) {
            List row = (List)lines.get(i);
            result[i] = row.toArray(new String[row.size()]);
        }
        return result;
    }

    private static char findSeparator(String data) {
        char[] potential = new char[]{',', '\t', '|', ';'};
        char best = ',';
        int score = -100000;
        int N = Math.min(5000, data.length());
        for (int i = 0; i < 4; ++i) {
            char trial = potential[i];
            int[] count = new int[]{0, 0};
            int line = 0;
            for (int j = 0; j < N && line < 2; ++j) {
                char s = data.charAt(j);
                if (s == trial) {
                    int n = line;
                    count[n] = count[n] + 1;
                }
                if (s != '\n') continue;
                ++line;
            }
            int trialScore = count[0];
            if (count[0] != count[1] || count[0] == 0) {
                trialScore -= 10000;
            }
            if (trialScore <= score) continue;
            best = trial;
            score = trialScore;
        }
        return best;
    }

    private static String saveMemory(String s, Map<String, String> common) {
        String t = common.get(s);
        if (t == null) {
            common.put(s, s);
            return s;
        }
        return t;
    }

    public static Field[] makeFields(Object[][] data) {
        Field[] fields = new Field[data[0].length];
        for (int i = 0; i < fields.length; ++i) {
            Object[] column = new Object[data.length - 1];
            for (int j = 0; j < column.length; ++j) {
                column[j] = data[j + 1][i];
            }
            String name = data[0][i] == null ? "" : data[0][i].toString();
            fields[i] = Data.makeColumnField(CSV.identifier(name), CSV.readable(name), column);
        }
        return fields;
    }

    public static String identifier(String text) {
        int parenthesis = text.indexOf(40);
        if (parenthesis > 0) {
            text = text.substring(0, parenthesis).trim();
        }
        String result = "";
        String last = "X";
        for (int i = 0; i < text.length(); ++i) {
            String d;
            String c = text.substring(i, i + 1);
            if (CSV.isDigit(c)) {
                if (i == 0) {
                    result = "_";
                }
                d = c;
            } else {
                d = c.equals("_") || CSV.isLower(c) || CSV.isUpper(c) || CSV.isDigit(c) ? c : "_";
            }
            if (d.equals("_")) {
                if (!last.equals("_")) {
                    result = result + d;
                }
            } else {
                result = result + d;
            }
            last = d;
        }
        return result.length() == 0 ? "_" : result;
    }

    public static String readable(String text) {
        String[] parts = text.split(" ");
        ArrayList<String> result = new ArrayList<String>();
        for (String part : parts) {
            String built = "";
            for (int at = 0; at < part.length(); ++at) {
                String c = part.substring(at, at + 1);
                if (at == 0 && CSV.isLower(c)) {
                    c = c.toUpperCase();
                    built = built + c;
                    continue;
                }
                if (at > 0 && !CSV.isLower(c) && CSV.isLower(part.substring(at - 1, at))) {
                    result.add(built);
                    part = part.substring(at);
                    built = "" + c;
                    at = 0;
                    continue;
                }
                built = built + c;
            }
            if (built.length() <= 0) continue;
            result.add(built);
        }
        return Data.join(result, " ");
    }

    private static boolean isDigit(String c) {
        return "0123456789".indexOf(c) >= 0;
    }

    private static boolean isLower(String c) {
        return "abcdefghijklmnopqrstuvwxyz".indexOf(c) >= 0;
    }

    private static boolean isUpper(String c) {
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(c) >= 0;
    }
}

