/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.brunel.action.Param;
import org.brunel.build.AbstractBuilder;
import org.brunel.build.DataTransformParameters;
import org.brunel.build.ElementDependency;
import org.brunel.build.controls.Controls;
import org.brunel.build.d3.D3DataBuilder;
import org.brunel.build.d3.D3ElementBuilder;
import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.D3ScaleBuilder;
import org.brunel.build.util.BuilderOptions;
import org.brunel.build.util.PositionFields;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.model.VisItem;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class D3Builder
extends AbstractBuilder {
    private static final String COPYRIGHT_COMMENTS = "<!--\n\tD3 Copyright \u00a9 2012, Michael Bostock\n\tjQuery Copyright \u00a9 2010 by The jQuery Project\n\tsumoselect Copyright \u00a9 2014 Hemant Negi\n -->\n";
    private ScriptWriter out;
    private int chartIndex;
    private int elementIndex;
    private int visWidth;
    private int visHeight;
    private String chartClass;
    private D3ScaleBuilder scalesBuilder;
    private D3Interaction interaction;
    private PositionFields positionFields;
    private Integer[] elementBuildOrder;

    private D3Builder(BuilderOptions options) {
        super(options);
    }

    @Override
    public String makeImports() {
        String pattern = "<script src=\"%s\" charset=\"utf-8\"></script>\n";
        String base = COPYRIGHT_COMMENTS + String.format(pattern, "http://cdnjs.cloudflare.com/ajax/libs/d3/3.5.5/d3.min.js");
        if (this.getControls().isNeeded()) {
            base = base + String.format(pattern, "http://code.jquery.com/jquery-1.10.2.js") + String.format(pattern, "http://code.jquery.com/ui/1.11.4/jquery-ui.js");
        }
        if (this.options.localResources == null) {
            base = base + String.format(pattern, "http://brunelvis.org/js/brunel." + this.options.version + ".min.js");
            if (this.getControls().isNeeded()) {
                base = base + String.format(pattern, "http://brunelvis.org/js/brunel.controls." + this.options.version + ".min.js");
            }
        } else {
            base = base + String.format(pattern, this.options.localResources + "/BrunelData.js") + String.format(pattern, this.options.localResources + "/BrunelD3.js");
            if (this.getControls().isNeeded()) {
                base = base + String.format(pattern, this.options.localResources + "/BrunelEventHandlers.js") + String.format(pattern, this.options.localResources + "/BrunelJQueryControlFactory.js") + String.format(pattern, this.options.localResources + "/sumoselect/jquery.sumoselect.min.js");
            }
        }
        return base;
    }

    public String makeStyleSheets() {
        String pattern = "<link rel=\"stylesheet\" type=\"text/css\" href=\"%s\" charset=\"utf-8\"></script>\n";
        String base = this.options.localResources == null ? String.format(pattern, "http://brunelvis.org/js/brunel." + this.options.version + ".css") : String.format(pattern, this.options.localResources + "/BrunelBaseStyles.css");
        if (this.getControls().isNeeded()) {
            base = base + String.format(pattern, "http://code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css") + String.format(pattern, "http://brunelvis.org/js/sumoselect.css");
        }
        return base;
    }

    public static D3Builder make(BuilderOptions options) {
        return new D3Builder(options);
    }

    public static D3Builder make() {
        return D3Builder.make(new BuilderOptions());
    }

    @Override
    public Object getVisualization() {
        return this.out.content();
    }

    @Override
    protected String defineVisSystem(VisItem main, int width, int height) {
        this.visWidth = width;
        this.visHeight = height;
        this.out = new ScriptWriter(this.options.readableJavascript);
        this.chartIndex = 0;
        this.out.add("function ", this.options.className, "(visId) {").ln().indentMore();
        this.out.add("\"use strict\";").comment("Strict Mode");
        this.out.onNewLine().ln();
        this.out.add("var datasets = [],").at(40).comment("Array of datasets for the original data");
        this.out.add("    pre = function(d, i) { return d },").at(40).comment("Default pre-process does nothing");
        this.out.add("    post = function(d, i) { return d },").at(40).comment("Default post-process does nothing");
        this.out.add("    transitionTime = 200,").at(40).comment("Transition time for animations");
        this.out.add("    charts = [],").at(40).comment("The charts in the system");
        this.out.add("    vis = d3.select('#' + visId).attr('class', 'brunel')").comment("the SVG container");
        return this.options.visIdentifier;
    }

    @Override
    protected String defineChart(double[] location, VisSingle[] elements, Dataset[] elementData) {
        this.positionFields = new PositionFields(elements, elementData);
        this.elementBuildOrder = this.makeBuildOrder(elements);
        this.elementIndex = 0;
        this.chartClass = "chart" + (this.chartIndex + 1);
        double[] chartMargins = new double[]{(double)this.visHeight * location[0] / 100.0, (double)this.visWidth * location[1] / 100.0, (double)this.visHeight * (1.0 - location[2] / 100.0), (double)this.visWidth * (1.0 - location[3] / 100.0)};
        this.out.titleComment("Define chart #" + this.chartIndex, "in the visualization");
        this.out.add("charts[" + this.chartIndex, "] = function() {").ln();
        this.out.indentMore();
        double chartWidth = (double)this.visWidth - chartMargins[1] - chartMargins[3];
        double chartHeight = (double)this.visHeight - chartMargins[0] - chartMargins[2];
        this.scalesBuilder = new D3ScaleBuilder(elements, elementData, this.positionFields, chartWidth, chartHeight, this.out);
        double[] margins = this.scalesBuilder.marginsTLBR();
        this.out.add("var geom = BrunelD3.geometry(vis.node(),", chartMargins, ",", margins, ")").endStatement();
        if (this.scalesBuilder.coords == VisTypes.Coordinates.transposed) {
            this.out.add("geom.transpose()").endStatement();
        }
        this.out.add("var elements = [];").at(40).comment("Array of elements in this chart");
        this.out.titleComment("Define groups for the chart parts");
        this.interaction = new D3Interaction(elements, this.positionFields, this.scalesBuilder, this.out);
        this.writeMainGroups();
        this.out.titleComment("Scales");
        this.scalesBuilder.writeCoordinateScales(this.interaction);
        if (this.scalesBuilder.needsAxes()) {
            this.out.titleComment("Axes");
            this.scalesBuilder.writeAxes();
        }
        ++this.chartIndex;
        return this.chartClass;
    }

    private Integer[] makeBuildOrder(final VisSingle[] elements) {
        Integer[] order = new Integer[elements.length];
        for (int i = 0; i < order.length; ++i) {
            order[i] = i;
        }
        Arrays.sort(order, new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                return elements[a.intValue()].fKeys.size() - elements[b.intValue()].fKeys.size();
            }
        });
        return order;
    }

    @Override
    protected String defineElement(VisSingle vis, Dataset data, int datasetIndex, ElementDependency dependency) {
        this.out.titleComment("Define element #" + (this.elementIndex + 1));
        this.out.add("elements[" + this.elementIndex + "] = function() {").indentMore();
        this.out.onNewLine().add("var original, processed,").at(40).comment("data sets passed in and then transformed").indentMore().onNewLine().add("element,").at(40).comment("Brunel element information").onNewLine().add("data, layout,").at(40).comment("Brunel data and layout method").onNewLine().add("d3Data, d3Layout,").at(40).comment("D3 versions").onNewLine().add("selection;").at(40).comment("D3 selection").indentLess();
        this.addElementGroups();
        D3DataBuilder dataBuilder = new D3DataBuilder(vis, this.out, data, datasetIndex);
        dataBuilder.writeDataManipulation(this.createResultFields(vis));
        this.scalesBuilder.writeAestheticScales(vis);
        this.scalesBuilder.writeLegends(vis);
        this.defineElementBuildFunction(vis, data, dependency);
        this.addElementExports(vis);
        this.out.indentLess().onNewLine().add("}()").endStatement().ln();
        return "element" + ++this.elementIndex;
    }

    private Map<String, Integer> createResultFields(VisSingle vis) {
        LinkedHashSet<String> needed = new LinkedHashSet<String>();
        if (vis.fY.size() > 1) {
            if (vis.stacked) {
                needed.add("#values$lower");
                needed.add("#values$upper");
            }
            needed.add("#series");
            needed.add("#values");
            for (Param p : vis.fX) {
                needed.add(p.asField());
            }
            Collections.addAll(needed, vis.nonPositionFields());
        } else {
            if (vis.stacked) {
                String y = vis.fY.get(0).asField();
                needed.add(y + "$lower");
                needed.add(y + "$upper");
            }
            Collections.addAll(needed, vis.usedFields(true));
        }
        needed.add("#row");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (String s : needed) {
            result.put(s, result.size());
        }
        return result;
    }

    private void defineElementBuildFunction(VisSingle vis, Dataset data, ElementDependency dependency) {
        D3ElementBuilder elementBuilder = new D3ElementBuilder(vis, this.out, this.scalesBuilder, this.positionFields, data, dependency);
        this.out.titleComment("Build element (data has been built)");
        this.out.add("function build(transitionMillis) {").ln().indentMore();
        elementBuilder.generate(this.elementIndex);
        this.interaction.addElementHandlers(vis);
        this.out.indentLess().onNewLine().add("}").endStatement().ln();
    }

    @Override
    protected void endVisSystem(VisItem main, String currentVisualizationID) {
        this.out.titleComment("Expose the needed Visualization functions and fields");
        this.out.add("function setData(rowData, i) { datasets[i||0] = BrunelData.Dataset.makeFromRows(rowData) }").endStatement();
        this.out.add("function getData(i) { return datasets[i||0] }").endStatement();
        this.out.add("function buildSystem() {").ln().indentMore().add("for (var i=0;i<arguments.length;i++) setData(arguments[i], i)").endStatement().add("charts.forEach(function(x) {x.build(transitionTime)})").endStatement();
        this.out.ln().indentLess().add("}").endStatement().ln();
        this.out.add("function rebuildSystem(time) {").ln().indentMore().add("time = (time == null) ? 20 : time").endStatement().add("charts.forEach(function(x) {x.build(time)})").endStatement();
        this.out.ln().indentLess().add("}").endStatement().ln();
        this.out.add("return {").indentMore().ln().add("dataPreProcess:").at(24).add("function(f) { if (f) pre = f; return pre },").ln().add("dataPostProcess:").at(24).add("function(f) { if (f) post = f; return post },").ln().add("data:").at(24).add("function(d,i) { if (d) setData(d,i); return datasets[i||0] },").ln().add("visId:").at(24).add("visId,").ln().add("build:").at(24).add("buildSystem,").ln().add("rebuild:").at(24).add("rebuildSystem,").ln().add("charts:").at(24).add("charts").ln().indentLess().add("}").endStatement();
        this.out.indentLess().onNewLine().add("}").endStatement();
        D3DataBuilder.writeTables(main, this.out, this.options);
        if (this.options.generateBuildCode) {
            this.out.titleComment("Call Code to Build the system");
            this.out.add("var v = new", this.options.className, "(" + this.out.quote(this.options.visIdentifier) + ")").endStatement();
            int length = main.getDataSets().length;
            this.out.add("v.build(");
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    this.out.add(", ");
                }
                this.out.add(String.format(this.options.dataName, i + 1));
            }
            this.out.add(")").endStatement();
        }
        this.controls.write(this.out);
    }

    public Controls getControls() {
        return this.controls;
    }

    @Override
    protected void endChart(String currentChartID) {
        int i;
        int i$;
        int len$;
        Integer[] arr$;
        this.out.onNewLine().add("function build(time) {").indentMore();
        this.out.onNewLine().add("var first = elements[0].data() == null").endStatement();
        this.out.add("if (first) time = 0;").comment("No transition for first call");
        if (this.scalesBuilder.needsAxes()) {
            this.out.onNewLine().add("buildAxes(); ");
        }
        this.out.onNewLine().add("if (first || time>0) ");
        if (this.elementBuildOrder.length > 1) {
            this.out.add("{").indentMore();
            arr$ = this.elementBuildOrder;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                i = arr$[i$];
                this.out.onNewLine().add("elements[" + i + "].makeData();");
            }
            this.out.indentLess().onNewLine().add("}").endStatement();
        } else {
            this.out.add("elements[0].makeData()").endStatement();
        }
        arr$ = this.elementBuildOrder;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            i = arr$[i$];
            this.out.onNewLine().add("elements[" + i + "].build(time);");
        }
        this.out.indentLess().onNewLine().add("}").endStatement().ln();
        this.out.comment("Expose the following components of the chart");
        this.out.add("return {").indentMore().onNewLine().add("build : build,").onNewLine().add("elements : elements").onNewLine().indentLess().add("}").endStatement();
        this.out.indentLess().add("}()").endStatement().ln();
    }

    @Override
    protected DataTransformParameters modifyParameters(DataTransformParameters params, VisSingle vis) {
        String stackCommand = "";
        String sortCommand = params.sortCommand;
        if (vis.stacked) {
            if (vis.fY.size() > 1) {
                stackCommand = "#values";
            } else if (vis.fY.size() == 1) {
                stackCommand = vis.fY.get(0).asField();
            }
            stackCommand = stackCommand + "; " + Data.join(vis.fX) + "; " + Data.join((Object[])vis.aestheticFields()) + "; " + vis.tElement.producesSingleShape;
        } else if (vis.tElement == VisTypes.Element.line || vis.tElement == VisTypes.Element.area) {
            String x = vis.fX.get(0).asField() + ":ascending";
            sortCommand = sortCommand.isEmpty() ? x : sortCommand + "; " + x;
        }
        return new DataTransformParameters(params.constantsCommand, params.filterCommand, params.transformCommand, params.summaryCommand, stackCommand, sortCommand, params.seriesCommand, params.usedCommand);
    }

    private void writeMainGroups() {
        String axesTransform = this.makeTranslateTransform("geom.inner_left", "geom.inner_top");
        this.out.add("var chart = vis.append('g').attr('class', '" + this.chartClass + "')").addChained(this.makeTranslateTransform("geom.chart_left", "geom.chart_top")).endStatement();
        this.out.add("var interior = chart.append('g').attr('class', 'interior')").addChained(axesTransform).addChained("attr('clip-path', 'url(#" + this.clipID() + ")')").endStatement();
        this.interaction.addPrerequisites();
        this.out.add("var axes = chart.append('g').attr('class', 'axis')").addChained(axesTransform).endStatement();
        this.out.add("var legends = chart.append('g').attr('class', 'legend')").addChained(this.makeTranslateTransform("geom.outer_width", "0")).endStatement();
        this.out.add("vis.append('clipPath').attr('id', '" + this.clipID() + "').append('rect')");
        this.out.addChained("attr('x', -1).attr('y', -1)");
        if (this.scalesBuilder.coords == VisTypes.Coordinates.transposed) {
            this.out.addChained("attr('width', geom.inner_height+2).attr('height', geom.inner_width+2)").endStatement();
        } else {
            this.out.addChained("attr('width', geom.inner_width+2).attr('height', geom.inner_height+2)").endStatement();
        }
    }

    private void addElementGroups() {
        String elementTransform = this.makeElementTransform(this.scalesBuilder.coords);
        this.out.add("var elementGroup = interior.append('g').attr('class', 'element" + (this.elementIndex + 1) + "')");
        if (elementTransform != null) {
            this.out.addChained(elementTransform);
        }
        if (this.scalesBuilder.isDiagram) {
            this.out.continueOnNextLine(",").add("diagramExtras = elementGroup.append('g').attr('class', 'extras')");
        }
        this.out.continueOnNextLine(",").add("main = elementGroup.append('g').attr('class', 'main')");
        if (this.scalesBuilder.isDiagram) {
            this.out.continueOnNextLine(",").add("diagramLabels = elementGroup.append('g').attr('class', 'extras')");
        }
        this.out.continueOnNextLine(",").add("labels = elementGroup.append('g').attr('class', 'labels')").endStatement();
    }

    private String clipID() {
        return "clip_" + this.options.visIdentifier + "_" + this.chartIndex;
    }

    private void addElementExports(VisSingle vis) {
        this.out.add("return {").indentMore();
        this.out.onNewLine().add("data:").at(24).add("function() { return processed },");
        this.out.onNewLine().add("internal:").at(24).add("function() { return data },");
        this.out.onNewLine().add("makeData:").at(24).add("makeData,");
        this.out.onNewLine().add("build:").at(24).add("build,");
        this.out.onNewLine().add("fields: {").indentMore();
        this.writeFieldName("x", vis.fX);
        this.writeFieldName("y", vis.fY);
        this.writeFieldName("color", vis.fColor);
        this.writeFieldName("size", vis.fSize);
        this.writeFieldName("opacity", vis.fOpacity);
        this.out.onNewLine().indentLess().add("}");
        this.out.indentLess().onNewLine().add("}").endStatement();
    }

    private String makeTranslateTransform(String dx, String dy) {
        return "attr('transform','translate(' + " + dx + " + ',' + " + dy + " + ')')";
    }

    private String makeElementTransform(VisTypes.Coordinates coords) {
        if (coords == VisTypes.Coordinates.transposed) {
            return "attr('transform','matrix(0,1,1,0,0,0)')";
        }
        if (coords == VisTypes.Coordinates.polar) {
            return this.makeTranslateTransform("geom.inner_width/2", "geom.inner_height/2");
        }
        return null;
    }

    private void writeFieldName(String name, List<Param> fieldNames) {
        ArrayList<String> names = new ArrayList<String>();
        for (Param p : fieldNames) {
            names.add(p.asField());
        }
        if (!fieldNames.isEmpty()) {
            this.out.onNewLine().add(name, ":").at(24).add("[").addQuotedCollection(names).add("],");
        }
    }
}

