/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;

public class Param
implements Comparable<Param> {
    private final Object content;
    private final Type type;
    private final Param[] modifiers;

    public static Param makeString(String s) {
        return new Param(s, Type.string, new Param[0]);
    }

    public static Param makeNumber(Number s) {
        return new Param(s, Type.number, new Param[0]);
    }

    public static Param makeOption(String s) {
        return new Param(s, Type.option, new Param[0]);
    }

    public static Param makeField(String s) {
        return new Param(s, Type.field, new Param[0]);
    }

    public static List<Param> makeFields(String[] fields) {
        ArrayList<Param> items = new ArrayList<Param>(fields.length);
        for (String f : fields) {
            items.add(Param.makeField(f));
        }
        return items;
    }

    private Param(Object content, Type type, Param ... modifiers) {
        if (content == null) {
            throw new NullPointerException("ActionParameter content must be defined");
        }
        this.content = content;
        this.type = type;
        this.modifiers = modifiers;
    }

    public Param addModifiers(Param ... mods) {
        if (this.modifiers == null) {
            return new Param(this.content, this.type, mods);
        }
        Param[] combined = new Param[this.modifiers.length + mods.length];
        System.arraycopy(this.modifiers, 0, combined, 0, this.modifiers.length);
        System.arraycopy(mods, 0, combined, this.modifiers.length, mods.length);
        return new Param(this.content, this.type, combined);
    }

    public double asDouble() {
        if (this.type == Type.number) {
            return ((Number)this.content).doubleValue();
        }
        return Double.parseDouble(this.content.toString());
    }

    public String asField(Dataset data) {
        String name = this.content.toString();
        if (this.type == Type.field) {
            if (name.startsWith("#")) {
                return name.toLowerCase();
            }
            if (data == null) {
                return name;
            }
            Field field = data.field(name, true);
            if (field == null) {
                throw new IllegalArgumentException("Cannot find field '" + name + "' in the data");
            }
            return field.name;
        }
        return "'" + name + "'";
    }

    public String asField() {
        return this.asField(null);
    }

    public String asString() {
        if (this.type == Type.number) {
            return Data.formatNumeric((double)this.asDouble(), (boolean)false);
        }
        return this.content.toString();
    }

    @Override
    public int compareTo(Param o) {
        if (this.type != o.type) {
            return this.type.ordinal() - o.type.ordinal();
        }
        int n = Data.compare((Object)this.content, (Object)o.content);
        if (n != 0) {
            return n;
        }
        for (int i = 0; i < this.modifiers.length && i < o.modifiers.length; ++i) {
            int m = this.modifiers[i].compareTo(o.modifiers[i]);
            if (m == 0) continue;
            return m;
        }
        return this.modifiers.length - o.modifiers.length;
    }

    public Param firstModifier() {
        return this.modifiers.length == 0 ? null : this.modifiers[0];
    }

    public boolean hasModifiers() {
        return this.modifiers.length > 0;
    }

    public int hashCode() {
        return 31 * this.content.hashCode() + this.type.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Param that = (Param)o;
        return this.type == that.type && this.content.equals(that.content) && Arrays.equals(this.modifiers, that.modifiers);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.type == Type.string) {
            b.append('\'');
        }
        b.append(this.asString());
        if (this.type == Type.string) {
            b.append('\'');
        }
        for (Param p : this.modifiers) {
            b.append(':').append(p.toString());
        }
        return b.toString();
    }

    public boolean isField() {
        return this.type == Type.field;
    }

    public Param[] modifiers() {
        return this.modifiers;
    }

    public Type type() {
        return this.type;
    }

    public static enum Type {
        field,
        option,
        number,
        string;

    }
}

