/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.action;

import java.util.Arrays;
import java.util.Set;
import org.brunel.action.Param;
import org.brunel.action.parse.ParseGrammar;
import org.brunel.data.Data;
import org.brunel.model.VisException;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

class ActionStep {
    private static final Set<String> SUMMARY_METHODS = ParseGrammar.instance().getSummaryMethods();
    private static final Set<String> TRANSFORM_METHODS = ParseGrammar.instance().getTransformMethods();
    final String name;
    final Param[] parameters;

    ActionStep(String actionName, Param ... params) {
        this.name = actionName.toLowerCase();
        this.parameters = params;
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + Arrays.hashCode(this.parameters);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionStep)) {
            return false;
        }
        ActionStep other = (ActionStep)obj;
        return this.name.equals(other.name) && Arrays.equals(this.parameters, other.parameters);
    }

    public String toString() {
        if (this.parameters.length == 0) {
            return this.name;
        }
        return this.name + '(' + Data.join((Object[])this.parameters) + ')';
    }

    VisSingle apply(VisSingle item) {
        try {
            if (this.name.equals("x")) {
                item.x(this.parameters);
                return item;
            }
            if (this.name.equals("y")) {
                item.y(this.parameters);
                return item;
            }
            if (this.name.equals("yrange")) {
                if (this.parameters.length < 1 || this.parameters.length > 2) {
                    throw new IllegalArgumentException("yrange requires 1-2 fields");
                }
                if (this.parameters.length == 1) {
                    item.yrange(this.parameters[0], this.parameters[0]);
                } else {
                    item.yrange(this.parameters[0], this.parameters[1]);
                }
                return item;
            }
            if (this.name.equals("color")) {
                item.color(this.parameters);
                return item;
            }
            if (this.name.equals("opacity")) {
                item.opacity(this.parameters);
                return item;
            }
            if (this.name.equals("size")) {
                item.size(this.parameters);
                return item;
            }
            if (this.name.equals("split")) {
                item.split(this.parameters);
                return item;
            }
            if (this.name.equals("label")) {
                item.label(this.parameters);
                return item;
            }
            if (this.name.equals("tooltip")) {
                item.tooltip(this.parameters);
                return item;
            }
            if (TRANSFORM_METHODS.contains(this.name)) {
                item.transform(this.name, this.parameters);
                return item;
            }
            if (SUMMARY_METHODS.contains(this.name)) {
                item.summarize(this.name, this.parameters);
                return item;
            }
            if (this.name.equals("sort")) {
                item.sort(this.parameters);
                return item;
            }
            if (this.name.equals("at")) {
                item.at(this.parameters);
                return item;
            }
            if (this.name.equals("filter")) {
                item.filter(this.parameters);
                return item;
            }
            if (this.name.equals("key")) {
                item.key(this.parameters);
                return item;
            }
            if (this.name.equals("style")) {
                item.style(this.oneParam());
                return item;
            }
            if (this.name.equals("axes")) {
                item.axes(this.oneParam());
                return item;
            }
            if (this.name.equals("legends")) {
                item.legends(this.oneParam());
                return item;
            }
            if (this.name.equals("interaction")) {
                item.interaction(this.parameters);
                return item;
            }
            if (this.name.equals("transpose")) {
                item.transpose();
                return item;
            }
            if (this.name.equals("polar")) {
                item.polar();
                return item;
            }
            if (this.name.equals("stack")) {
                item.stack();
                return item;
            }
            if (this.name.equals("using")) {
                item.using(this.oneParam());
                return item;
            }
            if (this.name.equals("flipx")) {
                item.flipx();
                return item;
            }
            if (this.name.equals("flip")) {
                item.flip();
                return item;
            }
            if (this.name.equals("data")) {
                item.data(this.parameters);
                return item;
            }
            for (VisTypes.Element element : VisTypes.Element.values()) {
                if (!element.name().equals(this.name)) continue;
                item.element(element);
                return item;
            }
            for (Enum enum_ : VisTypes.Diagram.values()) {
                if (!enum_.name().equals(this.name)) continue;
                item.diagram((VisTypes.Diagram)enum_);
                return item;
            }
            throw new IllegalArgumentException("Cannot apply '" + this.name + "' to this item");
        }
        catch (Exception ex) {
            throw VisException.makeApplying(ex, this);
        }
    }

    private Param oneParam() {
        return this.parameters.length > 0 ? this.parameters[this.parameters.length - 1] : null;
    }
}

