/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import morfologik.stemming.EncoderType;
import morfologik.tools.FSABuildTool;
import morfologik.tools.SequenceAssembler;
import morfologik.tools.SequenceEncoders;
import morfologik.tools.SharedOptions;
import morfologik.tools.Tool;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringEscapeUtils;

class MorphEncodingTool
extends Tool {
    private static Charset US_ASCII = Charset.forName("US-ASCII");
    private boolean noWarn = false;
    private SequenceAssembler encoder;
    private byte separatorByte;
    private char separator;

    MorphEncodingTool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void go(CommandLine line) throws Exception {
        this.noWarn = line.hasOption(SharedOptions.noWarnIfTwoFields.getOpt());
        EncoderType encType = EncoderType.SUFFIX;
        if (line.hasOption(SharedOptions.encoder.getOpt())) {
            String encValue = line.getOptionValue(SharedOptions.encoder.getOpt());
            try {
                encType = EncoderType.valueOf(encValue.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid encoder: " + encValue + ", " + "allowed values: " + Arrays.toString((Object[])EncoderType.values()));
            }
        }
        this.separator = (char)43;
        if (line.hasOption(SharedOptions.annotationSeparatorCharacterOption.getLongOpt())) {
            String sep = line.getOptionValue(SharedOptions.annotationSeparatorCharacterOption.getLongOpt());
            if ((sep = StringEscapeUtils.unescapeJava(sep)).length() != 1) {
                throw new IllegalArgumentException("Field separator must be a single character: " + sep);
            }
            if (sep.charAt(0) > '\u00ff') {
                throw new IllegalArgumentException("Field separator not within byte range: " + sep.charAt(0));
            }
            this.separator = sep.charAt(0);
            this.separatorByte = FSABuildTool.checkSingleByte(Character.toString(this.separator), Charset.defaultCharset());
        }
        this.encoder = new SequenceAssembler(SequenceEncoders.forType(encType), (byte)this.separator);
        DataInputStream input = MorphEncodingTool.initializeInput(line);
        DataOutputStream output = MorphEncodingTool.initializeOutput(line);
        try {
            this.process(input, output);
            output.flush();
        }
        finally {
            input.close();
            output.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(DataInputStream input, DataOutputStream output) throws IOException {
        long lnumber = 0L;
        try {
            int dataByte;
            int bufPos = 0;
            byte[] buf = new byte[]{};
            ArrayList<byte[]> columns = new ArrayList<byte[]>();
            block8: do {
                dataByte = input.read();
                switch (dataByte) {
                    case 13: {
                        break;
                    }
                    case 9: {
                        columns.add(Arrays.copyOf(buf, bufPos));
                        bufPos = 0;
                        break;
                    }
                    case -1: 
                    case 10: {
                        ++lnumber;
                        if (bufPos == 0 && columns.isEmpty()) {
                            if (dataByte == -1) continue block8;
                            System.err.println(String.format(Locale.ROOT, "Ignoring empty line %d.", lnumber));
                            break;
                        }
                        columns.add(Arrays.copyOf(buf, bufPos));
                        if (columns.size() < 2 || columns.size() > 3) {
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "Every \\n-delimited 'line' must contain 2 or 3 columns, line %d has %d. US-ASCII version of this line: %s", lnumber, columns.size(), this.toAscii(columns)));
                        }
                        if (columns.size() == 2 && !this.noWarn) {
                            System.err.println(String.format(Locale.ROOT, "Line %d has %d columns. US-ASCII version of this line: %s", lnumber, columns.size(), this.toAscii(columns)));
                        }
                        byte[] wordForm = (byte[])columns.get(0);
                        byte[] wordLemma = (byte[])columns.get(1);
                        if (this.contains(wordForm, this.separatorByte) || this.contains(wordLemma, this.separatorByte)) {
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "Either word or lemma in line %d contain the annotation byte '%s': %s", lnumber, Character.valueOf(this.separator), this.toAscii(columns)));
                        }
                        output.write(this.encoder.encode(wordForm, wordLemma, columns.size() > 2 ? columns.get(2) : null));
                        output.writeByte(10);
                        bufPos = 0;
                        columns.clear();
                        break;
                    }
                    default: {
                        if (bufPos >= buf.length) {
                            buf = Arrays.copyOf(buf, buf.length + 1024);
                        }
                        buf[bufPos++] = (byte)dataByte;
                    }
                }
            } while (dataByte != -1);
        }
        finally {
            input.close();
        }
    }

    private boolean contains(byte[] seq, byte b) {
        for (int i = 0; i < seq.length; ++i) {
            if (seq[i] != b) continue;
            return true;
        }
        return false;
    }

    private String toAscii(ArrayList<byte[]> columns) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                b.append("\t");
            }
            b.append(new String(columns.get(i), US_ASCII));
        }
        return b.toString();
    }

    @Override
    protected void initializeOptions(Options options) {
        options.addOption(SharedOptions.inputFileOption);
        options.addOption(SharedOptions.outputFileOption);
        options.addOption(SharedOptions.encoder);
        options.addOption(SharedOptions.noWarnIfTwoFields);
        options.addOption(SharedOptions.annotationSeparatorCharacterOption);
    }

    private static DataOutputStream initializeOutput(CommandLine line) throws IOException, ParseException {
        String opt = SharedOptions.outputFileOption.getOpt();
        DataOutputStream output = line.hasOption(opt) ? new DataOutputStream(new BufferedOutputStream(new FileOutputStream((File)line.getParsedOptionValue(opt)))) : new DataOutputStream(new BufferedOutputStream(System.out));
        return output;
    }

    private static DataInputStream initializeInput(CommandLine line) throws IOException, ParseException {
        String opt = SharedOptions.inputFileOption.getOpt();
        DataInputStream input = line.hasOption(opt) ? new DataInputStream(new BufferedInputStream(new FileInputStream((File)line.getParsedOptionValue(opt)))) : new DataInputStream(new BufferedInputStream(System.in));
        return input;
    }

    public static void main(String ... args) throws Exception {
        MorphEncodingTool tool = new MorphEncodingTool();
        tool.go(args);
    }
}

