r"""The top-level package for the library ``algebraixlib``.

Sub-packages:

-   :mod:`~.algebras`: Modules that represent :term:`algebra`\s and their operations.
-   :mod:`~.io`: Modules with facilities for importing and exporting data.
-   :mod:`~.mathobjects`: Modules that define the classes that represent data.
-   :mod:`~.util`: Miscellaneous utility modules.

Modules:

-   :mod:`~.extension`: Facilities for extending operations from one :term:`algebra` to another.
-   :mod:`~.partition`: Operations for partitioning :term:`set`\s and :term:`multiset`\s.
-   :mod:`~.structure`: Representation of the structure of a `MathObject`.
-   :mod:`~.undef`: Facilities for representing and working with the concept of "undefined".
"""

# $Id: __init__.py 22702 2015-07-28 20:20:56Z jaustell $
# Copyright Algebraix Data Corporation 2015 - $Date: 2015-07-28 15:20:56 -0500 (Tue, 28 Jul 2015) $
#
# This file is part of algebraixlib <http://github.com/AlgebraixData/algebraixlib>.
#
# algebraixlib is free software: you can redistribute it and/or modify it under the terms of version
# 3 of the GNU Lesser General Public License as published by the Free Software Foundation.
#
# algebraixlib is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
# even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License along with algebraixlib.
# If not, see <http://www.gnu.org/licenses/>.
# --------------------------------------------------------------------------------------------------
