'''
说明：这个配置文件是 for jxbase 这个包的

'''

# jxbase 要用到的所有依赖包在列在这里
MODULES_ARR = [
	'time',
	'datetime',
	'configobj',
	'copy',
	'csv',
	'ctypes',
	'decimal',
	'getopt',
	'inspect',
	'io',
	'itertools',
	'json',
	'logging',
	'math',
	'matplotlib',
	'multiprocessing',
	'numpy',
	'os',
	'pandas',
	'pickle',
	'platform',
	'pylab',
	'queue',
	'random',
	're',
	'reportlab',
	'requests',
	'subprocess',
	'scipy',
	'smtplib',
	'sympy',
	'sys',
	'tempfile',
	'threading',
	'tkinter',
	'urllib',
	'uuid',
	'win32gui',
	'win32api',
	'win32con',
	'win32print',
	'win32clipboard',
	'xmlrpc',

	'email',
	'binascii',
	'sqlalchemy',
	'ftplib',
	'lxml',
	'bs4',
	'PIL',

	'pymysql',
	'pytesseract',
	'tushare',
	'redis',
	'django',
	'pywinauto',
	'selenium',
	'apscheduler'
	]



# --------------
# DOS 风格
DOS_ARR = [
	'DOS',
	'dos'
	]


# WINDOWS 风格
WINDOWS_ARR = [
	'WINDOWS',
	'windows'
	]


# DOS 风格
LINUX_ARR = [
	'LINUX',
	'linux'
	]



# UNIX 风格
UNIX_ARR = [
	'UNIX',
	'unix'
	]


DOS_STYLE_ARR = DOS_ARR + WINDOWS_ARR
UNIX_STYLE_ARR = UNIX_ARR + LINUX_ARR



# --------------------------
# 程序中要用到的几种时间格式
TIME_FORMAT='%Y%m%d%H%M%S'
TIME_FORMAT1='%H:%M:%S'
TIME_FORMAT2='%Y%m%d-%H.%M.%S'
TIME_FORMAT3='%Y-%m-%d - %H:%M:%S'

DATE_FORMAT1='%Y-%m-%d'
DATE_FORMAT2='%d'
DATE_TIME_FORMAT = DATE_FORMAT1 + ' ' + TIME_FORMAT1


TIME_GAP = 0.05 			# UI操作间停留时间间隙，预设 0.1秒，主要用在 pywinauto 上，是为了等待前一个操作完成



# 定义数据源 URL 字典
URL_DICT={
	'163'		:'http://quotes.money.163.com/service/chddata.html?code=%s&start=%s&end=%s&fields=TOPEN;HIGH;LOW;TCLOSE;LCLOSE;CHG;PCHG;VOTURNOVER;VATURNOVER;TURNOVER;TCAP;MCAP', 		# 网易历史数据源
	'126live'	:'http://api.money.126.net/data/feed/%smoney.api' 			# 网易实时数据源
	}

# 要从网易拉取历史K线数据的各列名称：
# K线数据列头名称（有序），日期，股票代码，名称，开盘价，最高价，最低价，收盘价，昨收价，涨跌额，涨跌幅，成交量，成交额，换手率，总市值，流通值
K_COL_ARR=['date','code','name','open','high','low','close','last_close','price_change','percent_change','volume','amount','turnover','total_value','circulation_value']

# --------------------------------
# 指数 dict ，前面都加市场前缀，sh 表示上证指数， sz 表示深证指数
# 上海方面的指数dict，由于上证综指 000001 与深证市场平安银行代码 000001 冲突，故用 sh000001 代表上证综证，在向数据源拉数据时请自行转换
SH_INDEX_DICT = {
	'SHZZ':'sh000001',
	'shzz':'sh000001'
	}

# 深圳方面的指数，399001 是深证成指
SZ_INDEX_DICT = {
	'SZCZ':'sz399001', 			# 深证成指（大票集中度次于深证综指）
	'szcz':'sz399001',			
	'ZXBZ':'sz399005', 			# 中小板指（小票集中度次于创业板）
	'zxbz':'sz399005',
	'CYBZ':'sz399006', 			# 创业板指(小票最集中)
	'cybz':'sz399006',
	'SZZZ':'sz399106', 			# 深证综指（大票最集中）
	'szzz':'sz399106'
	}

# 这个数组存放大盘指数代码，包括上海和深圳的
INDEX_DICT=dict(list(SH_INDEX_DICT.items()) + list(SZ_INDEX_DICT.items())) 	# 两市指数DICT



# 各指数数组
SH_INDEX_ARR = list(set(SH_INDEX_DICT.values())) 			# set 是为了去除重复元素

SZ_INDEX_ARR = list(set(SZ_INDEX_DICT.values()))

# 指数数组
INDEX_ARR = list(set(INDEX_DICT.values()))


