/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.ldap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.services.persondir.support.MultivaluedPersonAttributeUtils;
import org.springframework.ldap.core.AttributesMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PersonAttributesMapper
implements AttributesMapper {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<String, Set<String>> ldapAttributesToPortalAttributes;

    public PersonAttributesMapper(Map<String, Set<String>> ldapAttributesToPortalAttributes) {
        if (ldapAttributesToPortalAttributes == null) {
            throw new IllegalArgumentException("ldapAttributesToPortalAttributes may not be null");
        }
        this.ldapAttributesToPortalAttributes = ldapAttributesToPortalAttributes;
    }

    public Map<String, Set<String>> getLdapAttributesToPortalAttributes() {
        return this.ldapAttributesToPortalAttributes;
    }

    public Object mapFromAttributes(Attributes attributes) throws NamingException {
        HashMap rowResults = new HashMap();
        for (Map.Entry<String, Set<String>> attributeMappingEntry : this.ldapAttributesToPortalAttributes.entrySet()) {
            String ldapAttributeName = attributeMappingEntry.getKey();
            Attribute attribute = attributes.get(ldapAttributeName);
            if (attribute == null) continue;
            Set<String> attributeNames = attributeMappingEntry.getValue();
            if (attributeNames == null) {
                attributeNames = Collections.singleton(ldapAttributeName);
            }
            int valueCount = 0;
            NamingEnumeration<?> attrValueEnum = attribute.getAll();
            while (attrValueEnum.hasMore()) {
                Object attributeValue = attrValueEnum.next();
                if (!(attributeValue instanceof byte[])) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)("Converting value " + valueCount + " of LDAP attribute '" + ldapAttributeName + "' from byte[] to String"));
                    }
                    attributeValue = attributeValue.toString();
                }
                for (String attributeName : attributeNames) {
                    MultivaluedPersonAttributeUtils.addResult(rowResults, attributeName, attributeValue);
                }
                ++valueCount;
            }
            if (!this.logger.isDebugEnabled()) continue;
            if (this.ldapAttributesToPortalAttributes.containsKey(ldapAttributeName)) {
                this.logger.debug((Object)("Added " + valueCount + " attributes under mapped names '" + attributeNames + "' for source attribute '" + ldapAttributeName + "'"));
                continue;
            }
            this.logger.debug((Object)("Added " + valueCount + " attributes for source attribute '" + ldapAttributeName + "'"));
        }
        return rowResults;
    }
}

