/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.jasig.services.persondir.support.AbstractDefaultAttributePersonAttributeDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueryPersonAttributeDao
extends AbstractDefaultAttributePersonAttributeDao {
    private List<String> queryAttributes = null;

    public final Map<String, List<Object>> getMultivaluedUserAttributes(Map<String, List<Object>> seed) {
        ArrayList<List<Object>> args;
        Validate.notNull(seed, (String)"seed may not be null.");
        if (this.queryAttributes != null && seed.keySet().containsAll(this.queryAttributes)) {
            args = new ArrayList(this.queryAttributes.size());
            for (String attrName : this.queryAttributes) {
                List<Object> value = seed.get(attrName);
                args.add(value);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Constructed argument array '" + args + "' from the queryAttributes List"));
            }
        } else if (this.queryAttributes == null && seed.containsKey(this.getDefaultAttributeName())) {
            String attrName = this.getDefaultAttributeName();
            args = Collections.singletonList(seed.get(attrName));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Constructed argument array '" + args + "' from the defaultAttributeName='" + attrName + "'"));
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"The seed does not contain the required information to run the query, returning null.");
            }
            return null;
        }
        return this.getUserAttributesIfNeeded(args);
    }

    protected Map<String, List<Object>> getUserAttributesIfNeeded(List<List<Object>> args) {
        Object[] queryArgumentArray = this.getQueryArgumentArray(args);
        return this.getUserAttributesIfNeeded(queryArgumentArray);
    }

    protected Map<String, List<Object>> getUserAttributesIfNeeded(Object[] args) {
        throw new UnsupportedOperationException("getUserAttributesIfNeeded(Object[]) is not implemented");
    }

    protected Object[] getQueryArgumentArray(List<List<Object>> args) {
        ArrayList<Object> queryArgs = new ArrayList<Object>(args.size());
        for (List<Object> arg : args) {
            Object value = arg.get(0);
            queryArgs.add(value);
        }
        return queryArgs.toArray();
    }

    public final List<String> getQueryAttributes() {
        return this.queryAttributes;
    }

    public final void setQueryAttributes(List<String> queryAttributes) {
        Validate.notNull(queryAttributes, (String)"queryAttributes cannot be null");
        this.queryAttributes = Collections.unmodifiableList(new LinkedList<String>(queryAttributes));
    }
}

