/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.services.persondir.IPersonAttributeDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFlatteningPersonAttributeDao
implements IPersonAttributeDao {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public final Map<String, Object> getUserAttributes(Map<String, Object> seed) {
        Validate.notNull(seed, (String)"seed may not be null.");
        Map<String, List<Object>> multiSeed = this.toMultivaluedSeed(seed);
        Map multivaluedUserAttributes = this.getMultivaluedUserAttributes(multiSeed);
        return this.flattenResults(multivaluedUserAttributes);
    }

    protected Map<String, List<Object>> toMultivaluedSeed(Map<String, Object> seed) {
        HashMap<String, List<Object>> multiSeed = new HashMap<String, List<Object>>(seed.size());
        for (Map.Entry<String, Object> seedEntry : seed.entrySet()) {
            String seedName = seedEntry.getKey();
            Object seedValue = seedEntry.getValue();
            multiSeed.put(seedName, Collections.singletonList(seedValue));
        }
        return multiSeed;
    }

    public final Map<String, Object> getUserAttributes(String uid) {
        Validate.notNull((Object)uid, (String)"uid may not be null.");
        Map multivaluedUserAttributes = this.getMultivaluedUserAttributes(uid);
        return this.flattenResults(multivaluedUserAttributes);
    }

    protected Map<String, Object> flattenResults(Map<String, List<Object>> multivaluedUserAttributes) {
        if (multivaluedUserAttributes == null) {
            return null;
        }
        HashMap<String, Object> userAttributes = new HashMap<String, Object>(multivaluedUserAttributes.size());
        for (Map.Entry<String, List<Object>> attrEntry : multivaluedUserAttributes.entrySet()) {
            String attrName = attrEntry.getKey();
            List<Object> attrValues = attrEntry.getValue();
            Object value = attrValues == null || attrValues.size() == 0 ? null : attrValues.get(0);
            userAttributes.put(attrName, value);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Flattened Map='" + multivaluedUserAttributes + "' into Map='" + userAttributes + "'"));
        }
        return userAttributes;
    }
}

