/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jasig.services.persondir.support.rule.AttributeRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleAttributeRule
implements AttributeRule {
    private final String whenKey;
    private final String whenPattern;
    private final String setKey;
    private final String setValue;
    private final Set<String> possibleAttributeNames;

    public SimpleAttributeRule(String whenKey, String whenPattern, String setKey, String setValue) {
        if (whenKey == null) {
            String msg = "Argument 'whenKey' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (whenPattern == null) {
            String msg = "Argument 'whenPattern' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (setKey == null) {
            String msg = "Argument 'setKey' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (setValue == null) {
            String msg = "Argument 'setValue' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        this.whenKey = whenKey;
        this.whenPattern = whenPattern;
        this.setKey = setKey;
        this.setValue = setValue;
        this.possibleAttributeNames = Collections.singleton(this.setKey);
    }

    @Override
    public boolean appliesTo(Map<String, List<Object>> userInfo) {
        if (userInfo == null) {
            String msg = "Argument 'userInfo' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        List<Object> value = userInfo.get(this.whenKey);
        if (value == null) {
            return false;
        }
        String[] compare = null;
        try {
            compare = value.toArray(new String[value.size()]);
        }
        catch (ClassCastException cce) {
            String msg = "List values may contain only String instances.";
            throw new RuntimeException(msg, cce);
        }
        boolean rslt = false;
        for (int i = 0; i < compare.length; ++i) {
            if (!compare[i].matches(this.whenPattern)) continue;
            rslt = true;
            break;
        }
        return rslt;
    }

    @Override
    public Map<String, List<Object>> evaluate(Map<String, List<Object>> userInfo) {
        if (userInfo == null) {
            String msg = "Argument 'userInfo' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (!this.appliesTo(userInfo)) {
            String msg = "May not evaluate.  This rule does not apply.";
            throw new IllegalArgumentException(msg);
        }
        HashMap<String, List<Object>> rslt = new HashMap<String, List<Object>>();
        ArrayList<String> value = new ArrayList<String>(1);
        value.add(this.setValue);
        rslt.put(this.setKey, value);
        return rslt;
    }

    @Override
    public Set<String> getPossibleUserAttributeNames() {
        return this.possibleAttributeNames;
    }
}

